/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author buhao
 * @version VerifyWithdrawalsRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class VerifyWithdrawalsRequest extends FbankRequest {
    /**
     * 调用方用户ID (Y <=40 调用方传递给企富通的用户 ID)
     */
    @NotNull
    private String custMerchantNo;
    /**
     * 币种 (Y 3 CNY：人民币)
     */
    @NotNull
    private String currency;
    /**
     * 交易金额 (Y <=15 单位是元，保留两位小数 0.00)
     */
    @NotNull
    private String tradeAmount;
    /**
     * 出账方账号 (Y 22 用户在企富通开立的账户号)
     */
    @NotNull
    private String virtualAccountOut;
    /**
     * 出账方账户名 (Y 32 用户在企富通开立的账户名称)
     */
    @NotNull
    private String virtualNameOut;
    /**
     * 入账方账号 (Y <=32 实体卡)
     */
    @NotNull
    private String accountIn;
    /**
     * 入账方姓名 (Y <=32 与入账方实体卡户名一致)
     */
    @NotNull
    private String nameIn;
    /**
     * 入账方账户类型 (Y 2 1：对私 2：对公)
     */
    @NotNull
    private String acctFlag;
    /**
     * 商户订单号 (Y 32 用户发起请求时由商户传递给企富通的唯一请求流水号，如响应失败，请重新生成。)
     */
    @NotNull
    private String bizChannelOrderid;
    /**
     * 银行简称 (C 20 对公提现时必输)
     */
    private String bankShortName;
    /**
     * 短信验证码 (N 6 测试环境是：000000，失效为10 分钟，有效期内最多只允许错五次)
     */
    private String activeCode;
    /**
     * 验证码交易流水号 (N N/A 调用 8.1 短信验证码发送返回的短信验证码流水号)
     */
    private String activeCodeSerialNo;
    /**
     * 手续费字段 (N <=15 单位是元，保留两位小数 0.00)
     */
    private String poundageAmount;
    /**
     * 交易备注 (N <=50 交易备注)
     */
    private String tradeRemark;

}