/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author buhao
 * @version UnbindCardRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class UnbindCardRequest extends FbankRequest {
    /**
     * 商户侧 (y 40)
     */
    @NotNull
    private String custMerchantNo;
    /**
     * 解绑卡类型 (y 1 2：入金卡 1：结算卡)
     */
    @NotNull
    private String cardType;
    /**
     * 解绑卡卡号 (y 40)
     */
    @NotNull
    private String originalCardNo;
    /**
     * 解绑卡图片 (N base64 格 式 ， 不 包 含base64 的头部信息，图片不超过 1.5M)
     */
    private String originalCardImage;
    /**
     * 解绑卡图片后缀 (N 10 仅支持如下格式：jpg/jpeg/png)
     */
    private String suffix;
    /**
     * 解绑卡账户名称 (y 60 解绑卡账户名称)
     */
    @NotNull
    private String custName;
    /**
     * 银行卡预留手机号 (c 11 解绑卡类型为对私卡时必传)
     */
    private String mobilePhoneNum;
    /**
     * 证件类型 (c 1 0：二代身份证 解绑卡类型为对私卡时必传)
     */
    private String custIdt;
    /**
     * 证件号 (c 18 证件号码 解绑卡类型为对私卡时必传)
     */
    private String custIdNo;

}