/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author buhao
 * @version PayCallbackRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class PayCallbackRequest extends FbankRequest {
    /**
     * 平台交易流水号 (Y 32 富民为订单生成平台唯一交易流水)
     */
    @NotNull
    private String tradeNo;
    /**
     * 子交易类型 (Y 详情参考交易查询接口)
     */
    @NotNull
    private String subTradeType;
    /**
     * 交易金额 (Y 该笔订单的金额，单 位元，小数点后两位)
     */
    @NotNull
    private String amount;
    /**
     * 交易备注 (Y <=50 交易时上送的交易备注)
     */
    @NotNull
    private String tradeRemark;
    /**
     * 交易状态 (Y 1：成功， 2：失败，15：已退汇)
     */
    @NotNull
    private String tradeStatus;
    /**
     * 商户订单号 (Y 商户请求平台的商户订单号)
     */
    @NotNull
    private String bizChannelOrderid;
    /**
     * 返回码 (Y 返回码)
     */
    @NotNull
    private String code;
    /**
     * 返回码描述 (Y 返回码描述)
     */
    @NotNull
    private String msg;
    /**
     * 交易完成时间 (Y 格式 yyyy-MM-dd HH:mm:ss)
     */
    @NotNull
    private String finishTime;
    /**
     * 商户号 (C 32 订单状态为已退汇(15)时，返回该字段，建议不依赖该字段)
     */
    private String merchantNo;
    /**
     * 退汇原因 (C 订单状态为已退汇(15)时，返回该字段，建议不依赖该字段)
     */
    private String remittanceReason;

}