/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author buhao
 * @version NewPersonalRealNameRequest.java, v 0.1 2020-10-16 16:49 buhao
 */
@Data
public class NewPersonalRealNameRequest extends FbankRequest {
    /**
     * 企富通账户号 (企富通为用户开立的账户号)
     */
    @NotNull
    private String accountNo;
    /**
     * 银行卡号 (仅限个人借记卡卡号，更新时不用传值)
     */
    private String acct;
    /**
     * 银行卡预留手机号 (银行卡在开户行预留的手机号，更新时不用传值)
     */
    private String mobilePhoneNum;
    /**
     * 姓名 (用户姓名)
     */
    @NotNull
    private String custName;
    /**
     * 证件类型 (枚举值: 0:二代身份证（目前仅支持二代身份证）)
     */
    @NotNull
    private String custIdt;
    /**
     * 证件号 (二代身份证号码)
     */
    @NotNull
    private String custIdNo;
    /**
     * 证件签发日 (身份证上的有效期限。日期格式：YYYY-MM-DD。)
     */
    @NotNull
    private String cardStartDate;
    /**
     * 证件到期日 (身份证上的有效期限。日期格式：YYYY-MM-DD。如果证件到期日期为“长期”，则传：“2999-12-31”。)
     */
    @NotNull
    private String cardEndDate;
    /**
     * 签发机关 (身份证上的签发机关)
     */
    private String cardIssuingAuthority;
    /**
     * 户籍地址 (为身份证上的住址)
     */
    @NotNull
    private String homeAddr;
    /**
     * 职业 (详见职业对照表 9.3职业枚举)
     */
    @NotNull
    private String professional;
    /**
     * 住所地 (现居住地)
     */
    private String apartment;
    /**
     * 地区码 (地区码)
     */
    @NotNull
    private String areaCode;
    /**
     * 身份证正面照 (jpg 格式，图片不超过 1.5M Base64编码的字符串)
     */
    @NotNull
    private String idCardFront;
    /**
     * 身份证背面照 (jpg 格式，图片不超过 1.5M Base64编码的字符串)
     */
    @NotNull
    private String idCardBack;
    /**
     * 实名类型 (枚举值：1：新增 2：新更)
     */
    @NotNull
    private String sign;
    /**
     * 短信验证码 (时效为10分钟，时效期内最多只允许错五次，更新时不用传值)
     */
    private String activeCode;
    /**
     * 验证码交易流水号 (调用8.1短信验证码发送返回的短信验证码流水号，更新时不用传值)
     */
    private String activeCodeSerialNo;
}