/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author buhao
 * @version NewPersonalAccountRequest.java, v 0.1 2020-10-16 15:50 buhao
 */
@Data
public class NewPersonalAccountRequest extends FbankRequest {
    /**
     * 调用方用户ID (调用方传递给企富通的用户 ID)
     */
    @NotNull
    private String custMerchantNo;
    /**
     * 会员姓名 (个人用户进行实名认证的姓名)
     */
    @NotNull
    private String custName;
    /**
     * 手机号 (此手机号必须是银行卡预留手机号。本接口也会也会使用此手机号码作为个人注册手机号。)
     */
    @NotNull
    private String mobilePhoneNum;
    /**
     * 卡号 (仅限个人借记卡卡号)
     */
    @NotNull
    private String acct;
    /**
     * 证件类型 (枚举值: 0:二代身份证（目前仅支持二代身份证）)
     */
    @NotNull
    private String custIdt;
    /**
     * 证件号 (二代身份证号码)
     */
    @NotNull
    private String custIdNo;
    /**
     * 证件签发日 (身份证上的有效期限。日期格式：YYYY-MM-DD。)
     */
    @NotNull
    private String cardStartDate;
    /**
     * 证件到期日 (身份证上的有效期限。日期格式：YYYY-MM-DD。如果证件到期日期为“长期”，则传：“2999-12-31”。)
     */
    @NotNull
    private String cardEndDate;
    /**
     * 签发机关 (身份证上的签发机关)
     */
    private String cardIssuingAuthority;
    /**
     * 户籍地址 (为身份证上的住址)
     */
    @NotNull
    private String homeAddr;
    /**
     * 职业 (详见职业对照表 9.3 职业枚举)
     */
    @NotNull
    private String professional;
    /**
     * 住所地 (现居住地)
     */
    private String apartment;
    /**
     * 地区码 (地区码)
     */
    @NotNull
    private String areaCode;
    /**
     * 身份证正面照 (jpg 格式，图片不超过 1.5M Base64 编码的字符串)
     */
    @NotNull
    private String idCardFront;
    /**
     * 身份证背面照 (jpg 格式，图片不超过 1.5M Base64 编码的字符串)
     */
    @NotNull
    private String idCardBack;
    /**
     * 短信验证码 (时效为 10 分钟，时效期内最多只允许错五次)
     */
    private String activeCode;
    /**
     * 验证码交易流水号 (调用 8.1 短信验证码发送返回的短信验证码流水号)
     */
    private String activeCodeSerialNo;
    /**
     * 注册手机号 (注册手机号)
     */
    private String registerPhone;
}