/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * 企富通请求
 *
 * @author buhao
 * @version FbankRequest.java, v 0.1 2020-10-15 13:57 buhao
 * @date 2020/10/15
 */
@Data
public class FbankRequest {
    /**
     * 商户编号
     */
    @Length(max = 16)
    private String merchantNo;
    /**
     * 日志流水号
     */
    @NotNull
    private String clientSerialNo;
}