/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import com.fshows.fbank.sdk.request.item.Beneficiary;
import com.fshows.fbank.sdk.request.item.Shareholder;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author buhao
 * @version EnterpriseAccountRegisterRequest.java, v 0.1 2020-10-16 17:30 buhao
 */
@Data
public class EnterpriseAccountRegisterRequest extends FbankRequest {
    /**
     * 调用方用户ID (调用方传递给企富通的用户ID)
     */
    @NotNull
    private String custMerchantNo;
    /**
     * 企业名称 (该企业的工商注册名称（与注册工商信息时一致）也作为该企业会员开立企富通账户的户名)
     */
    @NotNull
    private String entName;
    /**
     * 证件类型 (枚举值： 01：营业执照 02：统一社会信用代码 03：三证合一代码)
     */
    @NotNull
    private String enterpriseCardType;
    /**
     * 证件号码 (与企业证件类型对应的企业注册号（营业执照编号、统一社会信用代码、三证合一代码）)
     */
    @NotNull
    private String enterpriseRegistrationNo;
    /**
     * 法人姓名 (用于实名认证企业的法人姓名（与注册工商信息时一致）)
     */
    @NotNull
    private String corporationName;
    /**
     * 法人证件号码 (用于实名认证企业的法人身份证号码（与注册工商信息时一致）)
     */
    @NotNull
    private String corporationIdNo;
    /**
     * 法人证件签发日期yyyy-MM-dd (YYYY-MM-DD, 商户托底户为暂记户时必传)
     */
    private String corporationIdStartDate;
    /**
     * 法人证件到期日期yyyy-MM-dd (YYYY-MM-DD, 商户托底户为暂记户时必传,长期传2999-12-31)
     */
    private String corporationIdEndDate;
    /**
     * 手机号码 (用于该企业会员注册的手机号、账户对私时作为结算账户绑定手机号)
     */
    @NotNull
    private String custMobile;
    /**
     * 结算卡业务类型 (1-对公 2-对私)
     */
    @NotNull
    private String businessType;
    /**
     * 结算卡账户类型 (1-本行账户 2-他行账户 3-互金账户)
     */
    @NotNull
    private String acctType;
    /**
     * 账户名 (结算账户绑定、企富通账户开户、入金绑卡的户名；绑定卡是对公卡，户名是企业名称，如果对私，户名是法人姓名)
     */
    @NotNull
    private String accountName;
    /**
     * 银行简称 (绑定银行卡的所属银行简称。银行简称的值参见银行简称附录)
     */
    @NotNull
    private String bankCode;
    /**
     * 短信验证码 (时效为10分钟，时效期内最多只允许错五次)
     */
    private String activeCode;
    /**
     * 验证码交易流水号 (调用8.1短信验证码发送返回的短信验证码流水号)
     */
    private String activeCodeSerialNo;
    /**
     * 法人证件类型 (0：二代身份证（结算账户对私时必填）)
     */
    private String corporationIdType;
    /**
     * 联行号 (结算账户所属行的联行号)
     */
    private String bankOrgNo;
    /**
     * 实资金卡号 (入金绑卡的实资金账户)
     */
    private String realCapitalAcct;
    /**
     * 结算卡号 (该企业绑定的结算卡以及入金的对手行账户)
     */
    @NotNull
    private String acct;
    /**
     * 入金账户名 (入金账户名)
     */
    private String depositAccountName;
    /**
     * 经营地址 (商户托底户为暂记户时必传)
     */
    private String businessLocation;
    /**
     * 法人联系电话 (商户托底户为暂记户且客户细类为个体经营时必传)
     */
    private String corporationPhone;
    /**
     * 客户细类 (参考附录四，取值只能为大类200中的值，商户托底户为暂记户时必传)
     */
    private String category;
    /**
     * 企业证件图片base64 ()
     */
    private String businessLicenseImage;
    /**
     * 企业证件图片后缀 (商户托底户为暂记户时必传)
     */
    private String businessLicenseImageSuffix;
    /**
     * 法人身份证正面base64 ()
     */
    private String corporationCardFrontImage;
    /**
     * 法人身份证正面后缀 (商户托底户为暂记户时必传)
     */
    private String corporationCardFrontImageSuffix;
    /**
     * 法人身份证反面base64 ()
     */
    private String corporationCardReverseImage;
    /**
     * 法人身份证反面后缀 (商户托底户为暂记户时必传)
     */
    private String corporationCardReverseImageSuffix;
    /**
     * 法人户籍地址 (客户细类为个体经营时必传)
     */
    private String corporationHomeAddr;
    /**
     * 法人职业代码 (客户细类为个体经营时必传 详见职业对照表 9.3职业枚举)
     */
    private String corporationJob;
    /**
     * 法人常住地 (客户细类为个体经营时必传)
     */
    private String corporationPlace;
    /**
     * 企业联系电话 (商户托底户为暂记户时必传)
     */
    private String enterprisePhone;
    /**
     * 股东信息数组 C Array 数组元素不超过5个, 商户托底户为暂记户时必传，客户细类为个体经营时可不传
     */
    private List<Shareholder> shareholderList;
    /**
     * 受益人信息数组 C Array 数组元素不超过5个
     */
    private List<Beneficiary> beneficiaryList;
}