/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author buhao
 * @version DespositbindRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class DespositbindRequest extends FbankRequest {
    /**
     * 业务订单号 (Y 32 发起请求时由调用端传递给企富通的唯一请求流水号)
     */
    @NotNull
    private String bizChannelOrderid;
    /**
     * 商户侧用户唯一ID (Y <=40 调用端传递给企富通的企业用户唯一 ID)
     */
    @NotNull
    private String custMerchantNo;
    /**
     * 手机号 (Y 11 用于接收短信验证码信息的手机号，必须在企富通存档存在)
     */
    @NotNull
    private String custMobile;
    /**
     * 账户名称 (Y <=255 入账账户开户时的户名；备注：对公时，户名与企业实名名称一致；对私时，户名与企业实名法人名称一致)
     */
    @NotNull
    private String accountName;
    /**
     * 入账业务类型 (Y 1 0:个人 1：企业)
     */
    @NotNull
    private String custType;
    /**
     * 卡号 (Y <=40 需要绑定为入账卡的卡号)
     */
    @NotNull
    private String acct;
    /**
     * 银行简称 (C <=10 当入账业务类型为个人时：非必填； 当入账业务类型为企业时：必填； 需要绑定的结算卡的开卡行的银行简称，例：工商银行的银行简称：ICBC)
     */
    private String bankCode;
    /**
     * 银行支行号 (N <=100 入账卡的开卡行的支行行号)
     */
    private String branchBankNo;
    /**
     * 银行联行号 (N 13 入账卡的开卡银行的联行号)
     */
    private String acctOrgSeq;
    /**
     * 实资金账号 (N <=40)
     */
    private String realCapitalAcct;
    /**
     * 短信验证码 (N 6 测试环境是：000000，时效为 10分钟，有效期内只允许输错五次)
     */
    private String activeCode;
    /**
     * 验证码交易流水号 (N N/A 与短信验证码一一对应)
     */
    private String activeCodeSerialNo;

}