/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.common;

import java.text.MessageFormat;

/**
 * 企富通异常
 *
 * @author buhao
 * @version FBankException.java, v 0.1 2020-10-16 09:46 buhao
 * @date 2020/10/16
 */
public class FBankException extends RuntimeException {

    /**
     * 服务器异常
     */
    public static final FBankException SERVER_EXCEPTION = new FBankException("SERVER_ERROR", "调用企富通接口服务异常");
    /**
     * 业务异常
     */
    public static final FBankException BUSINESS_EXCEPTION = new FBankException("BUSINESS_ERROR", "调用企富通接口业务异常");
    protected String msg;
    protected String code;

    public FBankException(String code, String msgFormat, Object... args) {
        super(MessageFormat.format(msgFormat, args));
        this.code = code;
        this.msg = MessageFormat.format(msgFormat, args);
    }


    public FBankException() {
    }

    public FBankException(String message, Throwable cause) {
        super(message, cause);
    }

    public FBankException(Throwable cause) {
        super(cause);
    }

    public FBankException(String message) {
        super(message);
    }


    public FBankException newInstance(String msgFormat, Object... args) {
        return new FBankException(this.code, MessageFormat.format(msgFormat, args));
    }


    public String getMsg() {
        return this.msg;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public String getMessage() {
        return "[" + this.code + "]" + this.msg;
    }
}


