package com.fshows.com.fbank.openapi.sdk.crypto;

import com.fshows.com.fbank.openapi.sdk.constant.AlgorithmTypeEnum;
import com.fshows.com.fbank.openapi.sdk.util.AESUtils;

/**
 * AES-CBC加解密策略
 *
 * @author miwenming
 * @date 2020/5/21 11:56
 */
public class AESWithCBCStrategy implements CryptoEncryptionService {
    @Override
    public String encrypt(String data, String key) throws Exception {
        return AESUtils.encryptWithCBC(data, key);
    }

    @Override
    public String decrypt(String data, String key) throws Exception {
        return AESUtils.decryptWithCBC(data, key);
    }

    @Override
    public String getAlgorithmType() {
        return AlgorithmTypeEnum.AES_CBC.getAlgorithmType();
    }
}
