package com.fshows.com.fbank.openapi.sdk.client;

import java.io.Serializable;

/**
 * 请求业务接口的配置
 *
 * @author tyh
 * @date 2018/11/1
 */
public final class OpenParameters implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 服务名称标识
     */
    private String apiName;
    /**
     * 服务名称子服务标识
     */
    private String apiCode;
    /**
     * 服务模块
     */
    private String moduleCode;
    /**
     * 服务版本号
     */
    private String apiVersion;

    /**
     * H5请求时，当前操作用户的唯一编号
     */
    private String userId;
    /**
     * 请求业务报文体json字符串
     */
    private String params;

    private String fileName;

    private OpenParameters(Builder builder) {
        this.apiName = builder.apiName;
        this.apiCode = builder.apiCode;
        this.moduleCode = builder.moduleCode;
        this.apiVersion = builder.apiVersion;
        this.userId = builder.userId;
        this.params = builder.param;
        this.fileName = builder.fileName;
    }

    public String getApiName() {
        return apiName;
    }

    public String getApiCode() {
        return apiCode;
    }

    public String getModuleCode() {
        return moduleCode;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public String getUserId() {
        return userId;
    }

    public String getParams() {
        return params;
    }

    public String getFileName() {
        return fileName;
    }

    /**
     * builder for all our params
     */
    public static class Builder {
        private String apiName;
        private String apiCode;
        private String moduleCode;
        private String apiVersion;
        private String userId;
        private String param;
        private String fileName;

        public Builder() {
            // empty
        }

        public Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public Builder apiCode(String apiCode) {
            this.apiCode = apiCode;
            return this;
        }

        public Builder moduleCode(String moduleCode) {
            this.moduleCode = moduleCode;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder param(String param) {
            this.param = param;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }


        public OpenParameters build() {
            return new OpenParameters(this);
        }
    }

}
