/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.com.fbank.openapi.sdk.config;

import com.fshows.com.fbank.openapi.sdk.constant.AlgorithmTypeEnum;
import com.fshows.com.fbank.openapi.sdk.util.CertFileUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class Configuration {
    private static final int TIMEOUT_DEFAULT = 300000;

    public abstract String remoteAddress();

    public int connectionTimeout() {
        return 300000;
    }

    public int readTimeout() {
        return 300000;
    }

    public Charset charset() {
        return StandardCharsets.UTF_8;
    }

    public String signType() {
        return AlgorithmTypeEnum.RSA_SOFTWARE.getAlgorithmType();
    }

    public String encryptType() {
        return AlgorithmTypeEnum.AES_ECB.getAlgorithmType();
    }

    public abstract String fbankEncPubKey();

    public String fbankSignPubKey() {
        return this.fbankEncPubKey();
    }

    public String privateKey() {
        return CertFileUtils.getPrivateKeyFromPfxFile(this.pfxFileName(), this.pfxPassword());
    }

    public String pfxFileName() {
        return "Merchant_Private_CFCA_sandbox.pfx";
    }

    public String pfxPassword() {
        return "11111111";
    }

    public abstract String merchantNo();

    public String channelNo() {
        return "";
    }

    public abstract String appId();

    public abstract String siteId();
}

