/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.com.fbank.openapi.sdk.client;

import com.fshows.com.fbank.openapi.sdk.client.OpenParameters;
import com.fshows.com.fbank.openapi.sdk.config.Configuration;
import com.fshows.com.fbank.openapi.sdk.service.OpenApiCommonService;
import com.fshows.com.fbank.openapi.sdk.service.OpenApiFileDownloadService;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FBankOpenApiClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(FBankOpenApiClient.class);
    private Configuration configuration;

    public FBankOpenApiClient(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    private static void trustAllHttpsCertificates() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return hostname.equalsIgnoreCase(session.getPeerHost());
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            LOGGER.error("Invalid ssl for certs.", (Throwable)e);
        }
    }

    public String send(OpenParameters context) throws Exception {
        OpenApiCommonService openApiService = new OpenApiCommonService();
        return openApiService.execute(this, context);
    }

    public String downloadFile(OpenParameters context) throws Exception {
        OpenApiFileDownloadService openApiService = new OpenApiFileDownloadService();
        return openApiService.execute(this, context);
    }

    static {
        FBankOpenApiClient.trustAllHttpsCertificates();
    }
}

