/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.trade;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaoxumin
 * @version TerminalInfo.java, v 0.1 2023-10-27 14:35 zhaoxumin
 */
@Data
public class TerminalInfo implements Serializable {

    private static final long serialVersionUID = 620900450535936546L;
    /**
     * 终端应用程序的版本号
     */
    @JSONField(name = "app_version")
    private String appVersion;

    /**
     * 加密随机因子
     */
    @JSONField(name = "encrypt_rand_num")
    private String encryptRandNum;

    /**
     * ICCID，SIM 卡卡号
     */
    @JSONField(name = "icc_id")
    private String iccId;

    /**
     * 基站编号 1
     */
    @JSONField(name = "lbs_num1")
    private String lbsNum1;

    /**
     * 基站编号 2
     */
    @JSONField(name = "lbs_num2")
    private String lbsNum2;

    /**
     * 基站编号 3
     */
    @JSONField(name = "lbs_num3")
    private String lbsNum3;

    /**
     * 基站信号 1
     */
    @JSONField(name = "lbs_signal1")
    private String lbsSignal1;

    /**
     * 基站信号 2
     */
    @JSONField(name = "lbs_signal2")
    private String lbsSignal2;

    /**
     * 基站信号 3
     */
    @JSONField(name = "lbs_signal3")
    private String lbsSignal3;

    /**
     * 终端设备实时经纬度信息
     */
    @JSONField(name = "location")
    private String location;

    /**
     * 位置区域码 1
     */
    @JSONField(name = "location_cd1")
    private String locationCd1;

    /**
     * 位置区域码 2
     */
    @JSONField(name = "location_cd2")
    private String locationCd2;

    /**
     * 位置区域码 3
     */
    @JSONField(name = "location_cd3")
    private String locationCd3;

    /**
     * 基站信息，移动国家代码
     */
    @JSONField(name = "mobile_country_cd")
    private String mobileCountryCd;

    /**
     * 基站信息，移动网络识别码
     */
    @JSONField(name = "network_license")
    private String networkLicense;

    /**
     * 密文数据
     */
    @JSONField(name = "secret_text")
    private String secretText;

    /**
     * 终端设备的硬件序列号
     */
    @JSONField(name = "serial_num")
    private String serialNum;

    /**
     * 电信基站
     */
    @JSONField(name = "telecom_lbs")
    private String telecomLbs;

    /**
     * 电信基站信号
     */
    @JSONField(name = "telecom_lbs_signal")
    private String telecomLbsSignal;

    /**
     * 电信网络识别码
     */
    @JSONField(name = "telecom_net_id")
    private String telecomNetId;

    /**
     * 电信系统识别码
     */
    @JSONField(name = "telecom_sys_id")
    private String telecomSysId;

    /**
     * 终端设备编号
     */
    @JSONField(name = "terminal_id")
    private String terminalId;

    /**
     * 商户端终端设备 IP 地址
     */
    @JSONField(name = "terminal_ip")
    private String terminalIp;

    /**
     * 终端设备类型，受理方可参考终端注册时的设备类型填写
     */
    @JSONField(name = "terminal_type")
    private String terminalType;
}