/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.merchant.MerchantSignApplyResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author lyd
 * @version MerchantSignApplyRequest.java, v 0.1 2023-11-08 15:49 lyd
 */
@Data
public class MerchantSignApplyRequest extends EasyPayMerchantBaseRequest<MerchantSignApplyResponse> {

    private static final long serialVersionUID = 1809563351627653117L;

    /**
     * 商编
     */
    @NotBlank
    private String merTrace;

    /**
     * 报文类型
     */
    private String messageType = "CONTRACTAPPLY";

    @Override
    public Class<MerchantSignApplyResponse> getResponseClass() {
        return MerchantSignApplyResponse.class;
    }
}
