/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.merchant.ChannelMerchantAddResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhaoxumin
 * @version ChannelMerchantAddRequest.java, v 0.1 2025-11-11 13:32
 */
@Data
public class ChannelMerchantAddRequest extends EasyPayMerchantBaseRequest<ChannelMerchantAddResponse> {

    private static final long serialVersionUID = 4464352954499247339L;
    /**
     * 报文类型 SENDZFBORWX
     */
    private String messageType = "SENDZFBORWX";

    /**
     * 回调地址
     */
    private String backUrl;

    /**
     * 商户唯一标识
     */
    @NotBlank(message = "商户唯一标识不能为空")
    private String merTrace;

    /**
     * 操作流水 最长20字符
     */
    @NotBlank(message = "操作流水不能为空")
    private String operaTrace;

    /**
     * （微信）公众号名称-提前报备易生录入
     */
    private String pubName;

    /**
     * （支付宝）支付宝pid-提前报备易生录入
     */
    private String appId;

    /**
     * 入驻通道 unionPay-银联 netPay-网联
     */
    @NotBlank(message = "入驻通道不能为空")
    private String playType;

    /**
     * W-微信 Z-支付宝
     */
    @NotBlank(message = "交易类型不能为空")
    private String tradeType;

    /**
     * 是否小程序 0-非 1-是，默认 0
     */
    private String isMini;

    @Override
    public Class<ChannelMerchantAddResponse> getResponseClass() {
        return ChannelMerchantAddResponse.class;
    }
}