/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.easypay.sdk.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EasyPayRequestUtils {
    private static final Logger log = LoggerFactory.getLogger(EasyPayRequestUtils.class);
    private static final Map<Class, Field[]> CACHE_FIELD_MAP = new ConcurrentHashMap<Class, Field[]>();
    private static final String XML = "xml";
    private static final String DEFAULT_CHARSET = "GBK";
    private static final String EMPTY = "";
    private static final String[] IGNORE_FIELD_ARR = new String[]{"serialVersionUID"};
    private static Pattern UNDERLINE_PATTERN = Pattern.compile("[A-Z]");

    public static InputStream getStringStream(String sInputString) throws UnsupportedEncodingException {
        ByteArrayInputStream tInputStringStream = null;
        if (sInputString != null && !sInputString.trim().equals(EMPTY)) {
            tInputStringStream = new ByteArrayInputStream(sInputString.getBytes(DEFAULT_CHARSET));
        }
        return tInputStringStream;
    }

    public static <Res> Res getObjectFromXML(String xml, Class<Res> tClass) throws Exception {
        Map<String, String> mapFromXML = EasyPayRequestUtils.getMapFromXML(xml);
        return (Res)BeanUtil.toBean(mapFromXML, tClass);
    }

    public static <Res> Res getObjectFromMap(Map<String, Object> mapFromXML, Class<Res> tClass) {
        return (Res)BeanUtil.toBean(mapFromXML, tClass);
    }

    public static Map<String, String> toMap(Object obj) {
        Field[] fields = CACHE_FIELD_MAP.get(obj.getClass());
        if (fields == null) {
            fields = ReflectUtil.getFields(obj.getClass());
            CACHE_FIELD_MAP.put(obj.getClass(), fields);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                if (Modifier.isStatic(field.getModifiers()) || ArrayUtil.contains((Object[])IGNORE_FIELD_ARR, (Object)field.getName())) continue;
                String key = field.getName();
                Object val = field.get(obj);
                if (val != null) {
                    map.put(EasyPayRequestUtils.camelToUnderline(key), String.valueOf(val));
                    continue;
                }
                map.put(EasyPayRequestUtils.camelToUnderline(key), null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }

    public static Map<String, String> toMap(Object obj, boolean isHump) {
        Field[] fields = CACHE_FIELD_MAP.get(obj.getClass());
        if (fields == null) {
            fields = ReflectUtil.getFields(obj.getClass());
            CACHE_FIELD_MAP.put(obj.getClass(), fields);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Field field : fields) {
            try {
                field.setAccessible(true);
                if (Modifier.isStatic(field.getModifiers()) || ArrayUtil.contains((Object[])IGNORE_FIELD_ARR, (Object)field.getName())) continue;
                String key = field.getName();
                Object val = field.get(obj);
                if (val == null) continue;
                map.put(isHump ? key : EasyPayRequestUtils.camelToUnderline(key), String.valueOf(val));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }

    public static String calcExpireTime(Date now, String expireInMinutes, SimpleDateFormat dateFormat) {
        return dateFormat.format(now.getTime() + Long.parseLong(expireInMinutes) * 60L * 1000L);
    }

    public static String camelToUnderline(String str) {
        Matcher matcher = UNDERLINE_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static Map<String, String> getMapFromXML(String xmlString) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputStream is = EasyPayRequestUtils.getStringStream(xmlString);
        Document document = builder.parse(is);
        NodeList allNodes = document.getFirstChild().getChildNodes();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < allNodes.getLength(); ++i) {
            Node node = allNodes.item(i);
            if (!(node instanceof Element)) continue;
            map.put(node.getNodeName(), node.getTextContent());
        }
        return map;
    }

    public static String generateXml(Map<String, String> data) {
        StringBuilder xmlBuilder = new StringBuilder();
        xmlBuilder.append("<?xml version=\"1.0\" encoding=\"GBK\" standalone=\"yes\"?>");
        xmlBuilder.append("<xml>");
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            xmlBuilder.append("<").append(key).append(">").append(value).append("</").append(key).append(">");
        }
        xmlBuilder.append("</xml>");
        return xmlBuilder.toString();
    }
}

