/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.trade.scanpay;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaoxumin
 * @version UnQrAppReserved.java, v 0.1 2023-10-30 11:57 zhaoxumin
 */
@Data
public class UnQrAppReserved implements Serializable {

    private static final long serialVersionUID = -1117248627543841891L;
    /**
     * 活动编号
     */
    @JSONField(name = "activity_id")
    private String activityId;

    /**
     * 活动简称
     */
    @JSONField(name = "activity_nm")
    private String activityNm;

    /**
     * 活动打印信息
     */
    @JSONField(name = "addn_print_info")
    private String addnPrintInfo;

    /**
     * 卡号锁定标识
     */
    @JSONField(name = "card_number_lock")
    private String cardNumberLock;

    /**
     * 客户ID
     */
    @JSONField(name = "customer_id")
    private String customerId;

    /**
     * 总的优惠金额
     */
    @JSONField(name = "discount_amt")
    private String discountAmt;

    /**
     * 基金产品代码
     */
    @JSONField(name = "discount_code")
    private String discountCode;

    /**
     * 基金产品类型
     */
    @JSONField(name = "fund_pro_type")
    private String fundProType;

    /**
     * 商户优惠金额
     */
    @JSONField(name = "mcht_discount_amt")
    private String mchtDiscountAmt;
}