/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.trade.scanpay;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhaoxumin
 * @version PayDetail.java, v 0.1 2023-10-30 11:57 zhaoxumin
 */
@Data
public class PayDetail implements Serializable {

    private static final long serialVersionUID = 3738739834440137838L;
    /**
     * 支付宝支付渠道信息
     */
    @JSONField(name = "ali_fund_bill_list")
    private List<AliTradeFundBillUnder> aliFundBillList;

    /**
     * 支付宝花呗分期信息. {“USER_INSTALL_NUM”:”3”,”fq_amount”:”100.99”}
     */
    @JSONField(name = "ali_hb_fq_pay_info")
    private String aliHbFqPayInfo;

    /**
     * 付款方信息
     */
    @JSONField(name = "qr_payer_info")
    private QrPayerInfo qrPayerInfo;

    /**
     * 加密后的付款方信息
     */
    @JSONField(name = "qr_payer_info_str")
    private String qrPayerInfoStr;

    /**
     * 云闪付支付渠道信息
     */
    @JSONField(name = "unqrapp_info")
    private UnQrAppInfo unqrappInfo;

    /**
     * 微信银行类型
     */
    @JSONField(name = "wx_bank_type")
    private String wxBankType;
}