/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.trade.union;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.easypay.sdk.enums.EasyPayApiEnum;
import com.fshows.easypay.sdk.request.trade.EasyPayTradeDataBaseRequest;
import com.fshows.easypay.sdk.response.trade.union.UnionGetUserIdDataResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhaoxumin
 * @version JsapiDataRequest.java, v 0.1 2023-10-27 14:35 zhaoxumin
 */
@Data
public class UnionGetUserIdDataRequest extends EasyPayTradeDataBaseRequest<UnionGetUserIdDataResponse, EasyPayApiEnum> {

    private static final long serialVersionUID = 6405821387510764342L;
    /**
     * 授权码（付款方返回的临时授权码，一次有效）
     */
    @NotBlank
    @JSONField(name = "qr_user_auth_code")
    private String qrUserAuthCode;

    /**
     * 银联支付标识
     */
    @NotBlank
    @JSONField(name = "qr_app_up_identifier")
    private String qrAppUpIdentifier;
}