/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.trade.scanpay;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhaoxumin
 * @version AliGoodsDetail.java, v 0.1 2023-10-27 14:35 zhaoxumin
 */
@Data
public class AliGoodsDetail implements Serializable {

    private static final long serialVersionUID = 1855518615913875471L;
    /**
     * 支付宝定义的统一商品编号
     */
    @JSONField(name = "alipay_goods_id")
    private String alipayGoodsId;

    /**
     * 商品描述信息
     */
    private String body;

    /**
     * 商品类目树
     */
    @JSONField(name = "categories_tree")
    private String categoriesTree;

    /**
     * 商品类目
     */
    @JSONField(name = "goods_category")
    private String goodsCategory;

    /**
     * 商品的编号
     */
    @JSONField(name = "goods_id")
    private String goodsId;

    /**
     * 商品名称
     */
    @JSONField(name = "goods_name")
    private String goodsName;

    /**
     * 商品单价（单位：元）
     */
    private BigDecimal price;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 商品的展示地址
     */
    @JSONField(name = "show_url")
    private String showUrl;
}