/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.easypay.sdk.request.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.easypay.sdk.client.impl.EasyPayApiDefinition;
import com.fshows.easypay.sdk.request.base.EasyPayDataBaseRequest;
import com.fshows.easypay.sdk.response.base.EasyPayDataBaseResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 业务请求参数的基础父类
 *
 * @author zhaoxumin
 * @version EasyPayTradeDataBaseRequest.java, v 0.1 2023-10-27 13:38
 */
@Data
public class EasyPayQsTradeDataBaseRequest<T extends EasyPayDataBaseResponse, E extends EasyPayApiDefinition> extends EasyPayDataBaseRequest<T, E> implements Serializable {

    private static final long serialVersionUID = 4113093565730956796L;
    /**
     * 商户号
     */
    @NotBlank
    @JSONField(name = "org_mercode")
    private String orgMercode;

    /**
     * 终端号
     */
    @NotBlank
    @JSONField(name = "org_termno")
    private String orgTermno;

}