/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.trade.scanpay;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaoxumin
 * @version QrPayerInfo.java, v 0.1 2023-10-30 11:57 zhaoxumin
 */
@Data
public class QrPayerInfo implements Serializable {

    private static final long serialVersionUID = 548542206903015441L;
    /**
     * 完整的卡号/账号或token
     */
    @JSONField(name = "acc_no")
    private String accNo;

    /**
     * 账户类型
     */
    @JSONField(name = "acct_class")
    private String acctClass;

    /**
     * 卡属性
     */
    @JSONField(name = "card_attr")
    private String cardAttr;

    /**
     * 证件号码
     */
    @JSONField(name = "certif_id")
    private String certifId;

    /**
     * 证件类型
     */
    @JSONField(name = "certif_tp")
    private String certifTp;

    /**
     * cvn2
     */
    private String cvn2;

    /**
     * 卡有效期（YYMM)
     */
    private String expired;

    /**
     * 发卡机构代码
     */
    @JSONField(name = "iss_code")
    private String issCode;

    /**
     * 手机号（银行卡预留手机号）
     */
    private String mobile;

    /**
     * 付款方名称（个人账户可选，对公帐户必须填写完整户名）
     */
    private String name;

    /**
     * 付款银行信息
     */
    @JSONField(name = "payer_bank_info")
    private String payerBankInfo;
}