/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.trade.scanpay;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhaoxumin
 * @version DisCount.java, v 0.1 2023-10-30 11:57 zhaoxumin
 */
@Data
public class DisCount implements Serializable {

    private static final long serialVersionUID = 5108449690718710773L;
    /**
     * 支付宝打折商品信息
     */
    @JSONField(name = "ali_discount_goods_detail")
    private String aliDiscountGoodsDetail;

    /**
     * 交易支付使用的资金
     */
    @JSONField(name = "qr_coupon_info")
    private List<QrCouponInfo> qrCouponInfo;

    /**
     * 风险控制信息
     */
    @JSONField(name = "wx_promotion_detail_info")
    private List<WxPromotionDetail> wxPromotionDetailInfo;
}