/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.hardware;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.hardware.EquipmentBindResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author liubo
 * @version EasyPayEquipmentBindRequest.java, v 0.1 2023-11-13 11:09 liubo
 */
@Data
public class EquipmentBindRequest extends EasyPayMerchantBaseRequest<EquipmentBindResponse> {
    private static final long serialVersionUID = -7267515514694597679L;

    /**
     * 回调url
     */
    private String backUrl;

    /**
     * 商户唯一标识
     */
    private String merTrace;


    /**
     * 该字段为机构上送的操作流水号，机构唯一；用于查询操作结果；
     */
    @NotBlank
    @Length(max = 20, message = "operaTrace操作流水号长度不能超过20")
    private String operaTrace;

    /**
     * 终端信息
     */
    private String sysInfo;

    private String messageType = "ADDSYSTERM";

    @Override
    public Class<EquipmentBindResponse> getResponseClass() {
        return EquipmentBindResponse.class;
    }
}
