/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.trade.union;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.easypay.sdk.response.base.EasyPayDataBaseResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaoxumin
 * @version UnionGetUserIdDataResponse.java, v 0.1 2023-10-27 14:35 zhaoxumin
 */
@Data
public class UnionGetUserIdDataResponse extends EasyPayDataBaseResponse implements Serializable {

    private static final long serialVersionUID = -2916256369070678058L;
    /**
     * 附加状态码，一般为支付渠道原文返回
     */
    @JSONField(name = "append_retcode")
    private String appendRetcode;

    /**
     * 附加状态描述，一般为支付渠道原文返回
     */
    @JSONField(name = "append_retmsg")
    private String appendRetmsg;

    /**
     * 交易状态码
     */
    @JSONField(name = "fin_retcode")
    private String finRetcode;

    /**
     * 用户开放标识，用户ID
     */
    @JSONField(name = "payer_id")
    private String payerId;

    /**
     * 交易码—&showDoc
     */
    @JSONField(name = "trade_code")
    private String tradeCode;

    /**
     * 请求渠道-订单号；长度：50
     */
    @JSONField(name = "out_trace")
    private String outTrace;

    /**
     * 转出卡类型
     */
    @JSONField(name = "out_cdno_type")
    private String outCdnoType;

    /**
     * 风险控制信息
     */
    @JSONField(name = "risk_info")
    private String riskInfo;

    /**
     * 用户唯一编码
     */
    @JSONField(name = "user_id")
    private String userId;
}