/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.trade.jspai;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.easypay.sdk.response.base.EasyPayDataBaseResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaoxumin
 * @version JsapiDataResponse.java, v 0.1 2023-10-27 13:42
 */
@Data
public class JsapiDataResponse extends EasyPayDataBaseResponse implements Serializable {

    private static final long serialVersionUID = 4894487377412671864L;

    private JsapiAppendRespDataResponse appendData;

    /**
     * 附加状态码，一般为支付渠道原文返回
     */
    @JSONField(name = "append_retcode")
    private String appendRetcode;

    /**
     * 附加状态描述，一般为支付渠道原文返回
     */
    @JSONField(name = "append_retmsg")
    private String appendRetmsg;

    /**
     * 交易状态码
     */
    @JSONField(name = "fin_retcode")
    private String finRetcode;

    /**
     * 交易码
     */
    @JSONField(name = "trade_code")
    private String tradeCode;

    /**
     * 交易金额
     */
    @JSONField(name = "trade_amt")
    private Long tradeAmt;

    /**
     * 请求渠道-订单号；长度：50
     */
    @JSONField(name = "out_trace")
    private String outTrace;

    /**
     * 正常情况下按请求报文，原文返回；
     * 请求报文里上送希望D0清算，但商户功能未开通功能，或功能受限时返回值为：X
     */
    @JSONField(name = "patner_settle_flag")
    private String patnerSettleFlag;

    /**
     * 渠道返回-订单号。支付宝调用凭证
     * 前端实现指引：https://opendocs.alipay.com/open/common/105591#alipay.trade.create%20(%E7%BB%9F%E4%B8%80%E6%94%B6%E5%8D%95%E4%BA%A4%E6%98%93%E5%88%9B%E5%BB%BA%E6%8E%A5%E5%8F%A3)
     */
    @JSONField(name = "pc_trace")
    private String pcTrace;

    /**
     * 重定向地址，云闪付支付调用凭证
     */
    @JSONField(name = "qr_redirect_url")
    private String qrRedirectUrl;

    /**
     * 风险控制信息
     */
    @JSONField(name = "risk_info")
    private String riskInfo;

    /**
     * 用户唯一编码
     */
    @JSONField(name = "user_id")
    private String userId;

    /**
     * 微信，预支付交易会话标识
     * 前端实现指引：https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=7_7&index=6tradetype
     */
    @JSONField(name = "wx_prepay_id")
    private String wxPrepayId;

    /**
     * 微信，支付调用凭证。前端实现指引：微信:https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=23_9&index=1#menu1.1
     */
    @JSONField(name = "wx_wc_pay_data")
    private String wxWcPayData;
}