/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.merchant.MerchantInfoQueryResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangmj
 * @version MerchantInfoQueryRequest.java, v 0.1 2023-11-01 15:49 zhangmj
 */
@Data
public class MerchantInfoQueryRequest extends EasyPayMerchantBaseRequest<MerchantInfoQueryResponse> {

    private static final long serialVersionUID = 1809563351627653807L;

    /**
     * 商户唯一标识 60位
     */
    @NotBlank
    private String merTrace;

    /**
     * 报文类型
     */
    private String messageType = "QUERYMER";

    /**
     * 自定义信息
     */
    private String customInfo;

    @Override
    public Class<MerchantInfoQueryResponse> getResponseClass() {
        return MerchantInfoQueryResponse.class;
    }
}