/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.easypay.sdk.request.base.EasyPayAppendReqDataBaseRequest;
import com.fshows.easypay.sdk.request.trade.scanpay.AliBusinessParams;
import com.fshows.easypay.sdk.request.trade.scanpay.AliGoodsDetail;
import com.fshows.easypay.sdk.request.trade.scanpay.QrAcqAddnData;
import com.fshows.easypay.sdk.request.trade.scanpay.ScanPayWxSceneInfo;
import com.fshows.easypay.sdk.request.trade.scanpay.WxDetail;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author zhaoxumin
 * @version TradeAppendReqData.java, v 0.1 2023-10-27 14:35 zhaoxumin
 */
@Data
public class TradeAppendReqData extends EasyPayAppendReqDataBaseRequest implements Serializable {

    private static final long serialVersionUID = 7138678185298849579L;
    /**
     * 数字信封
     */
    @JSONField(name = "dgtl_envlp")
    private String dgtlEnvlp;

    /**
     * 实名支付；支付宝-支持上传所有字段：商户可直接使用；微信-仅支持W:开头的字段：并且需要向微信申请，仅支持商户为“保险”类目
     */
    private String identity;

    /**
     * 银联服务商机构标识码
     */
    @JSONField(name = "qr_pnr_ins_id_cd")
    private String qrPnrInsIdCd;

    /**
     * 终端信息
     */
    @NotNull
    private TerminalInfo terminalinfo;

    /**
     * wx:订单详情
     */
    @JSONField(name = "wx_detail")
    private WxDetail wxDetail;

    /**
     * wx:微信场景信息
     */
    @JSONField(name = "wx_scene_info")
    private ScanPayWxSceneInfo wxSceneInfo;

    /**
     * ali:禁用支付渠道,逗号分隔 https://docs.open.alipay.com/common/wifww7
     */
    @JSONField(name = "ali_disable_pay_channels")
    private String aliDisablePayChannels;

    /**
     * ali:可用支付渠道,逗号分隔,与aliDisablePayChannels互斥,被扫无法支持此字段 https://docs.open.alipay.com/common/wifww7
     */
    @JSONField(name = "ali_enable_pay_channels")
    private String aliEnablePayChannels;

    /**
     * ali:业务拓展信息，支持功能：花呗分期、信用卡分期
     * 信用卡分期【"extend_params" :{ "fq_num" : "3" , "fq_seller_percent" : "0", "fq_channels " : "alipayfq_cc"}
     * 花呗分期【"extend_params" :{ "hb_fq_num" : "3" , "hb_fq_seller_percent" : "0"】
     */
    @JSONField(name = "ali_extend_params")
    private String aliExtendParams;

    /**
     * ali:商品详情列表
     */
    @JSONField(name = "ali_goods_detail")
    private List<AliGoodsDetail> aliGoodsDetail;

    /**
     * ali:商户传入业务信息,用于安全/营销等参数直传场景, json
     */
    @JSONField(name = "ali_business_params")
    private AliBusinessParams aliBusinessParams;

    /**
     * ali:可打折金额
     */
    @JSONField(name = "ali_discountable_amount")
    private String aliDiscountableAmount;

    /**
     * ali:操作员编号
     */
    @JSONField(name = "ali_operator_id")
    private String aliOperatorId;

    /**
     * ali:卖家id
     */
    @JSONField(name = "ali_seller_id")
    private String aliSellerId;

    /**
     * ali:商户门店编号
     */
    @JSONField(name = "ali_store_id")
    private String aliStoreId;

//    /**
//     * ali:终端参数
//     */
//    @JSONField(name = "ali_terminal_params")
//    private AliTerminalParams aliTerminalParams;

    /**
     * ali:不可打折金额
     */
    @JSONField(name = "ali_undiscountable_amount")
    private String aliUndiscountableAmount;

    /**
     * ali:支付宝门店编号
     */
    @JSONField(name = "alipay_store_id")
    private String alipayStoreId;

    /**
     * qr:收款方附加数据；https://doc.eycard.cn/web/#/42?page_id=3594
     */
    @JSONField(name = "qr_acq_addn_data")
    private QrAcqAddnData qrAcqAddnData;

    /**
     * qr:特殊计费信息；固定长度3位。位置1~2：特殊计费类型；位置3：特殊计费档次
     */
    @JSONField(name = "qr_spec_fee_info")
    private String qrSpecFeeInfo;

    /**
     * 查询分期信息 例 “hbfq”
     */
    @JSONField(name = "query_options")
    private String queryOptions;
}