/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.order;

import com.fshows.easypay.sdk.enums.EasyPayApiEnum;
import com.fshows.easypay.sdk.request.trade.EasyPayTradeDataBaseRequest;
import com.fshows.easypay.sdk.response.order.EasyPayOrderCloseResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangmj
 * @version EasyPayOrderQueryRequest.java, v 0.1 2023-10-31 09:35 zhangmj
 */
@Data
public class EasyPayOrderCloseRequest extends EasyPayTradeDataBaseRequest<EasyPayOrderCloseResponse, EasyPayApiEnum> {

    private static final long serialVersionUID = -5722680117256256108L;

    private OrderAppendReqData appendData;
    /**
     * 交易流水，28位定长，规则：orgId 前四位+后四位+yyyyMMddhhmmss+6位自定义 合计28位长度（唯一）
     */
    private String oriOrgTrace;

    /**
     * 原outTrace
     */
    private String oriOutTrace;
}