/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.merchant.MerchantRateUpdateResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author zhubo
 * @version MerchantRateUpdateRequest.java, v 0.1 2023-11-09 10:37 zhubo
 */
@Data
public class MerchantRateUpdateRequest extends EasyPayMerchantBaseRequest<MerchantRateUpdateResponse> {
    private static final long serialVersionUID = -713310768613158850L;

    /**
     * 商户唯一标识
     */
    @NotBlank
    private String merTrace;

    /**
     * 报文类型
     */
    private String messageType = "ALTERFUNC";


    /**
     * 该字段为机构上送的操作流水号，机构唯一；用于查询操作结果；
     */
    @NotBlank
    @Length(max = 20, message = "operaTrace操作流水号长度不能超过20")
    private String operaTrace;

    /**
     * 终端信息
     */
    private String sysInfo;

    /**
     * 功能信息
     */
    @NotNull
    private List<String> funcInfo;

    /**
     * 产品信息
     * json 格式字符串 (list) 特殊场景下使用
     */
    private List<String> prodList;

    /**
     * json 格式字符串，需和易生约定特殊使用
     */
    private String customInfo;

    @Override
    public Class<MerchantRateUpdateResponse> getResponseClass() {
        return MerchantRateUpdateResponse.class;
    }
}
