package com.fshows.easypay.sdk.enums;

import com.fshows.easypay.sdk.client.impl.EasyPayApiDefinition;
import com.fshows.easypay.sdk.request.trade.jsapi.JsapiDataRequest;
import com.fshows.easypay.sdk.request.trade.scanpay.ScanPayDataRequest;
import com.fshows.easypay.sdk.request.trade.scanqrcode.ScanQrcodeDataRequest;
import com.fshows.easypay.sdk.request.trade.union.UnionGetUserIdDataRequest;
import com.fshows.easypay.sdk.response.refund.EasyPayOrderRefundBizResponse;
import com.fshows.easypay.sdk.response.refund.EasyPayRefundQueryBizResponse;
import com.fshows.easypay.sdk.response.scanqrcode.ScanQrcodeDataResponse;
import com.fshows.easypay.sdk.response.trade.jspai.JsapiDataResponse;
import com.fshows.easypay.sdk.response.trade.scanpay.ScanPayDataResponse;
import com.fshows.easypay.sdk.response.trade.union.UnionGetUserIdDataResponse;
import com.fshows.easypay.sdk.request.order.EasyPayOrderCloseRequest;
import com.fshows.easypay.sdk.request.order.EasyPayOrderQueryRequest;
import com.fshows.easypay.sdk.request.refund.EasyPayOrderRefundBizRequest;
import com.fshows.easypay.sdk.request.refund.EasyPayRefundQueryBizRequest;
import com.fshows.easypay.sdk.response.order.EasyPayOrderCloseResponse;
import com.fshows.easypay.sdk.response.order.EasyPayOrderQueryResponse;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author zhaoxumin
 * @version EasyPayBaseClient.java, v 0.1 2023-10-27 13:38
 */
@Getter
public enum EasyPayApiEnum implements EasyPayApiDefinition {

    /************** 支付相关 ************/

    STANDARD_SCAN_PAY(
            "付款码支付",
            "/standard/scanPay",
            ScanPayDataRequest.class,
            ScanPayDataResponse.class),

    STANDARD_JSAPI(
            "jsapi支付",
            "/standard/jsapi",
            JsapiDataRequest.class,
            JsapiDataResponse.class),

    STANDARD_NATIVE(
            "主扫支付（定额码）",
            "/standard/native",
            ScanQrcodeDataRequest.class,
            ScanQrcodeDataResponse.class),

    USERID_QR_GET_USERID(
            "云闪付获取用户标识",
            "/userId/qrGetUserId",
            UnionGetUserIdDataRequest.class,
            UnionGetUserIdDataResponse.class),

    ORDER_QUERY(
            "订单查询",
            "/standard/tradeQuery",
            EasyPayOrderQueryRequest.class,
            EasyPayOrderQueryResponse.class
    ),

    ORDER_CLOSE(
            "订单关闭",
            "/standard/close",
            EasyPayOrderCloseRequest.class,
            EasyPayOrderCloseResponse.class
    ),

    ORDER_REFUND(
            "订单退款",
            "/ledger/mposrefund",
            EasyPayOrderRefundBizRequest.class,
            EasyPayOrderRefundBizResponse.class
    ),

    REFUND_QUERY(
            "订单退款查询",
            "/ledger/mposfindrefund",
            EasyPayRefundQueryBizRequest.class,
            EasyPayRefundQueryBizResponse.class
    ),

    ;

    /**
     * 接口名称
     */
    private final String name;
    /**
     * 接口
     */
    private final String value;
    /**
     * 请求参数类型
     */
    private final Class requestClass;
    /**
     * 响应参数类型
     */
    private final Class responseClass;

    EasyPayApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static EasyPayApiEnum getByValue(String value) {
        EasyPayApiEnum[] valueList = EasyPayApiEnum.values();
        for (EasyPayApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getMethod(), value)) {
                return v;
            }
        }
        return null;
    }

    @Override
    public String getMethod() {
        return value;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}