/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.easypay.sdk.enums;

import com.fshows.easypay.sdk.client.impl.EasyPayApiDefinition;
import com.fshows.easypay.sdk.request.order.EasyPayOrderCloseRequest;
import com.fshows.easypay.sdk.request.order.EasyPayOrderQueryRequest;
import com.fshows.easypay.sdk.request.refund.EasyPayOrderRefundBizRequest;
import com.fshows.easypay.sdk.request.refund.EasyPayRefundQueryBizRequest;
import com.fshows.easypay.sdk.request.trade.jsapi.JsapiDataRequest;
import com.fshows.easypay.sdk.request.trade.scanpay.ScanPayDataRequest;
import com.fshows.easypay.sdk.request.trade.scanqrcode.ScanQrcodeDataRequest;
import com.fshows.easypay.sdk.request.trade.union.UnionGetUserIdDataRequest;
import com.fshows.easypay.sdk.response.order.EasyPayOrderCloseResponse;
import com.fshows.easypay.sdk.response.order.EasyPayOrderQueryResponse;
import com.fshows.easypay.sdk.response.refund.EasyPayOrderRefundBizResponse;
import com.fshows.easypay.sdk.response.refund.EasyPayRefundQueryBizResponse;
import com.fshows.easypay.sdk.response.scanqrcode.ScanQrcodeDataResponse;
import com.fshows.easypay.sdk.response.trade.jspai.JsapiDataResponse;
import com.fshows.easypay.sdk.response.trade.scanpay.ScanPayDataResponse;
import com.fshows.easypay.sdk.response.trade.union.UnionGetUserIdDataResponse;
import org.apache.commons.lang3.StringUtils;

public enum EasyPayApiEnum implements EasyPayApiDefinition
{
    STANDARD_SCAN_PAY("\u4ed8\u6b3e\u7801\u652f\u4ed8", "/standard/scanPay", ScanPayDataRequest.class, ScanPayDataResponse.class),
    STANDARD_JSAPI("jsapi\u652f\u4ed8", "/standard/jsapi", JsapiDataRequest.class, JsapiDataResponse.class),
    STANDARD_NATIVE("\u4e3b\u626b\u652f\u4ed8\uff08\u5b9a\u989d\u7801\uff09", "/standard/native", ScanQrcodeDataRequest.class, ScanQrcodeDataResponse.class),
    USERID_QR_GET_USERID("\u4e91\u95ea\u4ed8\u83b7\u53d6\u7528\u6237\u6807\u8bc6", "/userId/qrGetUserId", UnionGetUserIdDataRequest.class, UnionGetUserIdDataResponse.class),
    ORDER_QUERY("\u8ba2\u5355\u67e5\u8be2", "/standard/tradeQuery", EasyPayOrderQueryRequest.class, EasyPayOrderQueryResponse.class),
    ORDER_CLOSE("\u8ba2\u5355\u5173\u95ed", "/standard/close", EasyPayOrderCloseRequest.class, EasyPayOrderCloseResponse.class),
    ORDER_REFUND("\u8ba2\u5355\u9000\u6b3e", "/ledger/mposrefund", EasyPayOrderRefundBizRequest.class, EasyPayOrderRefundBizResponse.class),
    REFUND_QUERY("\u8ba2\u5355\u9000\u6b3e\u67e5\u8be2", "/ledger/mposfindrefund", EasyPayRefundQueryBizRequest.class, EasyPayRefundQueryBizResponse.class);

    private final String name;
    private final String value;
    private final Class requestClass;
    private final Class responseClass;

    private EasyPayApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static EasyPayApiEnum getByValue(String value) {
        EasyPayApiEnum[] valueList;
        for (EasyPayApiEnum v : valueList = EasyPayApiEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getMethod(), (CharSequence)value)) continue;
            return v;
        }
        return null;
    }

    @Override
    public String getMethod() {
        return this.value;
    }

    public Class getRequestClass() {
        return this.requestClass;
    }

    public Class getResponseClass() {
        return this.responseClass;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }
}

