/*
 * Decompiled with CFR 0.152.
 */
package com.fshows;

import cmbc.cfca.sm2.signature.SM2PrivateKey;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.util.CertUtil;
import cmbc.cfca.util.EnvelopeUtil;
import cmbc.cfca.util.KeyUtil;
import cmbc.cfca.util.SignatureUtil2;
import cmbc.cfca.util.cipher.lib.JCrypto;
import cmbc.cfca.util.cipher.lib.Session;
import cmbc.cfca.x509.certificate.X509Cert;
import cmbc.cfca.x509.certificate.X509CertHelper;
import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.fshows.CmbcClientConfigModel;
import com.fshows.apienum.CmbcTradeApiDefinitionEnum;
import com.fshows.request.CmbcBizRequest;
import com.fshows.response.CmbcBaseResponse;
import com.fshows.response.CmbcBizResponse;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.component.http.PostHttpRequestHandler;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmbcApiClient
extends AbstractApiClient<CmbcBizRequest, CmbcBaseResponse, CmbcTradeApiDefinitionEnum> {
    private static final Logger log = LoggerFactory.getLogger(CmbcApiClient.class);
    protected IHttpRequestHandler httpRequestHandler = new PostHttpRequestHandler();
    private static Session session;
    private static SM2PrivateKey priKey;
    private static X509Cert payCompanyPublicKeyCert;
    private static X509Cert fubeiPrivateKeyCert;

    public CmbcApiClient(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
        CmbcClientConfigModel configModel = (CmbcClientConfigModel)apiClientConfig;
        try {
            String fubeiPrivateKeyPath = configModel.getFubeiPrivateKeyPath();
            String payCompanyPublicKeyPath = configModel.getPayCompanyPublicKeyPath();
            String password = configModel.getPassword();
            priKey = KeyUtil.getPrivateKeyFromSM2((String)fubeiPrivateKeyPath, (String)password);
            payCompanyPublicKeyCert = X509CertHelper.parse((String)payCompanyPublicKeyPath);
            fubeiPrivateKeyCert = CertUtil.getCertFromSM2((String)fubeiPrivateKeyPath);
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"CmbcApiClient >> \u6c11\u751f\u94f6\u884c\u901a\u9053\u516c\u79c1\u94a5\u52a0\u8f7d\u5931\u8d25! ", (Throwable)e);
            throw new FsApiException("\u52a0\u8f7d\u516c\u79c1\u94a5\u5931\u8d25", (Throwable)e);
        }
    }

    public CmbcBaseResponse execute(CmbcBizRequest request, CmbcTradeApiDefinitionEnum apiDefinition) throws FsApiException {
        return (CmbcBaseResponse)this.doExecute(request, apiDefinition);
    }

    public CmbcBaseResponse execute(CmbcBizRequest request, CmbcTradeApiDefinitionEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return this.doExecute(request, apiDefinition, configModel);
    }

    protected CmbcBaseResponse doExecute(CmbcBizRequest request, CmbcTradeApiDefinitionEnum iApiDefinition, DefaultClientConfigModel customConfig) throws FsApiException {
        long beginTime = System.currentTimeMillis();
        LogUtil.info((Logger)log, (String)"{} >> \u6267\u884c\u8bf7\u6c42\u5f00\u59cb >> iApiDefinition={}, request={}", (Object[])new Object[]{this.getClientInfo().getClientDesc(), iApiDefinition, request});
        DefaultRequestContext requestContext = this.buildRequestContext(iApiDefinition, request, customConfig);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;
        try {
            this.checkParam(request, requestContext);
            apiRequestModel = this.buildApiRequestModel(request, requestContext);
            long reqBeginTime = System.currentTimeMillis();
            apiResponseModel = this.httpRequest(apiRequestModel, requestContext);
            long reqEndTime = System.currentTimeMillis();
            Object requestBody = ObjectUtils.defaultIfNull((Object)apiRequestModel.getRequestBody(), (Object)apiRequestModel.getRequestForm());
            LogUtil.debug((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u5bc6\u6587] >> url={}, method={}, request={}, response={}, cost={}ms, reqcost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, requestBody, apiResponseModel.getResponseBody(), System.currentTimeMillis() - beginTime, reqEndTime - reqBeginTime});
            CmbcBaseResponse response = this.buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u660e\u6587] >> url={}, method={}, request={}, response={}, totalcost={}ms, reqcost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)apiRequestModel.getRequest()), JSONObject.toJSONString((Object)apiResponseModel.getResponse()), System.currentTimeMillis() - beginTime, reqEndTime - reqBeginTime});
            return response;
        }
        catch (FsApiException e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u4e1a\u52a1\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            throw e;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u672a\u77e5\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u672a\u77e5\u5f02\u5e38[\u660e\u6587] >> url={}, method={}, request={}, cost={}ms", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel == null ? "" : apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)(apiRequestModel == null ? "" : apiRequestModel.getRequest())), System.currentTimeMillis() - beginTime});
            throw new FsApiException(e.getMessage(), (Throwable)e);
        }
    }

    protected DefaultRequestContext buildRequestContext(CmbcTradeApiDefinitionEnum tradeApiDefinitionEnum, CmbcBizRequest request, DefaultClientConfigModel customConfig) {
        DefaultRequestContext context = new DefaultRequestContext();
        context.setIApiDefinition((IApiDefinition)tradeApiDefinitionEnum);
        CmbcClientConfigModel clientConfig = (CmbcClientConfigModel)this.apiClientConfig;
        CmbcClientConfigModel config = (CmbcClientConfigModel)((Object)BeanUtil.copyProperties((Object)((Object)clientConfig), CmbcClientConfigModel.class, (String[])new String[0]));
        if (customConfig != null) {
            config.setAppId(StringUtils.isEmpty((CharSequence)customConfig.getAppId()) ? clientConfig.getAppId() : customConfig.getAppId());
        }
        context.setApiClientConfig((DefaultClientConfigModel)config);
        context.setClientInfoModel(this.getClientInfo());
        return context;
    }

    protected ApiRequestModel buildApiRequestModel(CmbcBizRequest request, DefaultRequestContext context) {
        CmbcClientConfigModel configModel = (CmbcClientConfigModel)context.getApiClientConfig();
        ApiRequestModel apiRequestModel = new ApiRequestModel();
        apiRequestModel.setApiURL(context.getApiClientConfig().getApiParentURL() + context.getIApiDefinition().getApiURI());
        Map requestParams = BeanUtil.beanToMap((Object)request);
        requestParams.put("platformId", configModel.getAppId());
        String requestJsonStr = JSONObject.toJSONString((Object)requestParams);
        String sign = CmbcApiClient.getSign(requestJsonStr, configModel);
        JSONObject signContext = new JSONObject();
        signContext.put("sign", (Object)sign);
        signContext.put("body", (Object)requestJsonStr);
        String encryptContext = CmbcApiClient.encrypt(signContext.toJSONString());
        JSONObject requestJson = new JSONObject();
        requestJson.put("businessContext", (Object)encryptContext);
        apiRequestModel.setRequestBody(requestJson.toJSONString());
        apiRequestModel.setRequest((IRequestDefinition)request);
        return apiRequestModel;
    }

    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientName("\u6c11\u751f\u94f6\u884c");
        clientInfoModel.setClientCode("cmbc-sdk");
        return clientInfoModel;
    }

    protected CmbcBaseResponse buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        String body;
        String encryptedBody;
        JSONObject resJson = JSONObject.parseObject((String)apiResponseModel.getResponseBody());
        CmbcBaseResponse response = (CmbcBaseResponse)resJson.toJavaObject(CmbcBaseResponse.class);
        if (response == null || StringUtils.isBlank((CharSequence)(encryptedBody = response.getBusinessContext()))) {
            return response;
        }
        String decryptContext = CmbcApiClient.decrypt(encryptedBody);
        JSONObject resultJson = JSONObject.parseObject((String)decryptContext);
        String sign = resultJson.getString("sign");
        if (!CmbcApiClient.signCheck(sign, body = resultJson.getString("body")).booleanValue()) {
            throw new FsApiException("\u9a8c\u7b7e\u5931\u8d25");
        }
        CmbcBizResponse cmbcBizResponse = (CmbcBizResponse)JSONObject.parseObject((String)body, (Class)requestContext.getIApiDefinition().getResponseClass());
        apiResponseModel.setResponse((IResponseDefinition)cmbcBizResponse);
        response.setDecryptBusinessContext(cmbcBizResponse);
        return response;
    }

    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Accept-Encoding", "identity");
        apiRequestModel.setHeadMap(headMap);
        return this.httpRequestHandler.httpRequest(apiRequestModel, requestContext);
    }

    private static String getSign(String context, CmbcClientConfigModel configModel) {
        String sign = "";
        try {
            sign = new String(new SignatureUtil2().p1SignMessage("SM3withSM2", context.getBytes(StandardCharsets.UTF_8), (PrivateKey)priKey, session));
        }
        catch (PKIException e) {
            e.printStackTrace();
        }
        return sign;
    }

    public static String encrypt(String signContext) {
        byte[] encryptedData = null;
        try {
            X509Cert[] certs = new X509Cert[]{payCompanyPublicKeyCert};
            encryptedData = EnvelopeUtil.envelopeMessage((byte[])signContext.getBytes(StandardCharsets.UTF_8), (String)"SM4/CBC/PKCS7Padding", (X509Cert[])certs);
        }
        catch (PKIException e) {
            e.printStackTrace();
        }
        return new String(encryptedData, StandardCharsets.UTF_8);
    }

    public static String decrypt(String encryptContext) {
        String decodeText = null;
        try {
            byte[] sourceData = EnvelopeUtil.openEvelopedMessage((byte[])encryptContext.getBytes(StandardCharsets.UTF_8), (PrivateKey)priKey, (X509Cert)fubeiPrivateKeyCert, (Session)session);
            decodeText = new String(sourceData, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decodeText;
    }

    public static Boolean signCheck(String sign, String body) {
        boolean signCheckSuccess = false;
        try {
            signCheckSuccess = new SignatureUtil2().p1VerifyMessage("SM3withSM2", body.getBytes(StandardCharsets.UTF_8), sign.getBytes(), payCompanyPublicKeyCert.getPublicKey(), session);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return signCheckSuccess;
    }

    static {
        try {
            JCrypto.getInstance().initialize("JSOFT_LIB", null);
            session = JCrypto.getInstance().openSession("JSOFT_LIB");
        }
        catch (PKIException e) {
            e.printStackTrace();
        }
    }
}

