/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import lombok.ToString;

/**
 * 统一下单 response
 *
 * @author
 * @version CmbcLcbpPayResponse.java, v 0.1 2025-02-10 15:37:48
 */
@Data
@ToString(callSuper = true)
public class CmbcLcbpPayResponse extends CmbcBizResponse {
    private static final long serialVersionUID = 7747802321155831974L;

    /**
     * 支付结果
     * E 订单失败
     * R 原订单成功，未支付（待支付）
     * S 订单成功
     */
    private String tradeStatus;

    /**
     * 支付要素
     * 微信/支付宝正扫下单返回 base64 二维码字符串；公众号支付 API 下单返回 prepay_id
     */
    private String payInfo;

    /**
     * 商户名
     */
    private String merchantName;

    /**
     * 商户订单号
     */
    private String merchantSeq;

    /**
     * 交易金额. 单位分
     */
    private Long amount;

    /**
     * 订单详情
     * 传入商品信息等
     */
    private String orderInfo;

    /**
     * 备注信息
     */
    private String remark;

    /**
     * 营销信息
     * 支付时未使用权益，redInfo 返回为空；
     * 若有权益返回 json 格式，如：{"red_total_amt":"","red_total_cnt":"","red_list":[{"red_org":"","red_name":"","red_type":"","refund_type":"","red_fav_amt":"","red_chnl":""},{}]}
     */
    private String redInfo;

    /**
     * 实付金额. 单位分
     */
    private String actualPayAmt;

    /**
     * 内部流水号
     * 收单的银行流水号（注：只有微信反扫免密支付成功返回）
     */
    private String bankTradeNo;

    /**
     * TPP 到第三方的（32 位流水号）（注：只有微信反扫 免密支付成功返回）
     */
    private String bankOrderNo;

    /**
     * 通道支付订单号
     * 第三方返回的支付订单号（注：只有微信反扫免密支付成功返回）
     */
    private String centerSeqId;

    /**
     * 检索参考号
     * （注：只有微信反扫免密支付成功返回）
     */
    private String refNo;

    /**
     * 交易日期. 格式yyyyMMdd
     * （注：只有微信反扫免密支付成功返回）
     */
    private String tranDate;

    /**
     * 交易时间. 格式HHMMSS
     * （注：只有微信反扫免密支付成功返回）
     */
    private String tranTime;
}