/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import lombok.ToString;

/**
 * 撤关单 response
 *
 * @author
 * @version CmbcCustomsClearCancelResponse.java, v 0.1 2025-02-10 15:37:48
 */
@Data
@ToString(callSuper = true)
public class CmbcCustomsClearCancelResponse extends CmbcBizResponse {
    private static final long serialVersionUID = 7894095360434217126L;

    /**
     * 接入平台号
     * 民生银行为接入平台分配的平台编号,与平台证书一一对应
     */
    private String platformId;

    /**
     * 商户号
     */
    private String merchantNo;

    /**
     * 响应时间. 格式yyyyMMddHHmmssSSS
     */
    private String outputTime;

    /**
     * 商户订单号
     */
    private String orderNo;

    /**
     * 交易结果
     * S 成功 E 失败 R 未知
     */
    private String tradeStatus;

    /**
     * 保留域
     */
    private String reserve;
}