/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import lombok.ToString;

/**
 * 订单退款 response
 *
 * @author
 * @version CmbcCancelTransResponse.java, v 0.1 2025-02-10 15:37:48
 */
@Data
@ToString(callSuper = true)
public class CmbcCancelTransResponse extends CmbcBizResponse {
    private static final long serialVersionUID = -912446637528336178L;

    /**
     * 回显商户名
     * 商户用于回显商户收款的名字
     */
    private String merchantName;

    /**
     * 商户订单号
     * 商户平台号+8位日期+商户自定的订单号
     */
    private String merchantSeq;

    /**
     * 交易金额. 单位分
     */
    private String amount;

    /**
     * 订单详情. 传入商品信息等
     */
    private String orderInfo;

    /**
     * 收单凭证号
     */
    private String voucherNo;

    /**
     * 银行流水号
     */
    private String bankTradeNo;

    /**
     * 交易结果
     * S 订单交易成功
     * E 订单失败
     * R 原订单成功，交易结果未知
     */
    private String tradeStatus;

    /**
     * 保留域
     */
    private String remark;
}