/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

/**
 * 订单查询 request
 *
 * @author
 * @version CmbcPaymentResultSelectNewRequest.java, v 0.1 2025-02-10 15:37:48
 */
@Data
@ToString(callSuper = true)
public class CmbcPaymentResultSelectNewRequest extends CmbcBizRequest {
    private static final long serialVersionUID = -1621426069446403020L;

    /**
     * 商户订单号
     * 原交易商户订单号
     * (选填)
     */
    @Length(max = 48, message = "商户订单号长度不能超过48")
    private String merchantSeq;

    /**
     * 商户流水号
     * 查询下单送下单时候的流水号，查退款送退款时的流水号，通过商户订单号查询时本字段必填
     * (选填)
     */
    @Length(max = 48, message = "商户流水号长度不能超过48")
    private String mchSeqNo;

    /**
     * 银行流水号
     * 微信/支付宝/银联系 app（例如：云闪付）账单详情中的条码
     * (选填)
     */
    private String bankOrderNo;

    /**
     * 原交易日期
     * 原下单支付交易日期，通过银行流水号查询时本字段必填
     * (选填)
     */
    private String oriTranDate;
}