/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 撤关单 request
 *
 * @author
 * @version CmbcCustomsClearCancelRequest.java, v 0.1 2025-02-10 15:37:48
 */
@Data
@ToString(callSuper = true)
public class CmbcCustomsClearCancelRequest extends CmbcBizRequest {
    private static final long serialVersionUID = 3540164170380174865L;

    /**
     * 商户流水号(保证唯一)
     * (必填)
     */
    @NotBlank(message = "商户流水号不能为空")
    @Length(max = 32, message = "商户流水号长度不能超过32")
    private String mchSeqNo;

    /**
     * 原交易商户订单号
     * 下单时上送的商户订单号
     * (必填)
     */
    @NotBlank(message = "原交易商户订单号不能为空")
    @Length(max = 48, message = "原交易商户订单号长度不能超过48")
    private String orderNo;

    /**
     * 备注信息
     */
    @Length(max = 1024, message = "备注信息长度不能超过1024")
    private String reserve;
}