/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 订单退款 request
 *
 * @author
 * @version CmbcCancelTransRequest.java, v 0.1 2025-02-10 15:37:48
 */
@Data
@ToString(callSuper = true)
public class CmbcCancelTransRequest extends CmbcBizRequest {
    private static final long serialVersionUID = -2771995265125191422L;

    /**
     * 原交易商户订单号
     * (必填)
     */
    @NotBlank(message = "商户订单号不能为空")
    @Length(max = 48, message = "商户订单号长度不能超过48")
    private String merchantSeq;

    /**
     * 商户退款流水号(保证唯一)
     * (必填)
     */
    @NotBlank(message = "商户流水号不能为空")
    @Length(max = 32, message = "商户流水号长度不能超过32")
    private String mchSeqNo;

    /**
     * 退款金额. 单位分
     * (必填)
     */
    @NotBlank(message = "退款金额不能为空")
    @Length(max = 20, message = "退款金额长度不能超过20")
    private String orderAmount;

    /**
     * 退款说明
     */
    private String orderNote;

    /**
     * 备注字段
     */
    private String reserve;
}