
/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.ccbpay.util;

import com.thoughtworks.xstream.io.naming.NameCoder;
import org.apache.commons.lang3.StringUtils;

/**
 * @author zhaoyi
 * @version UpperCaseNameCoder.java, v 0.1 2020-07-28 15:59 zhaoyi
 */
public class UpperCaseNameCoder implements NameCoder {

    /**
     * 下划线转换为驼峰
     */
    public static String underscore2CamelCase(String name) {
        name = StringUtils.lowerCase(name);
        StringBuilder translation = new StringBuilder();
        for (int i = 0; i < name.length(); i++) {
            char character = name.charAt(i);
            if (character == '_') {
                continue;
            }
            if (translation.length() != 0 && name.charAt(i - 1) == '_') {
                translation.append(Character.toUpperCase(character));
            } else {
                translation.append(character);
            }
        }
        return translation.toString();
    }

    @Override
    public String encodeNode(String name) {
        return name;
    }

    @Override
    public String encodeAttribute(String name) {
        return name;
    }

    @Override
    public String decodeNode(String nodeName) {
        return underscore2CamelCase(nodeName);
    }

    @Override
    public String decodeAttribute(String attributeName) {
        return attributeName;
    }
}
