/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.ccbpay.response.trade.order;

import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;
import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

/**
 * 订单状态轮询接口（在建行侧是轮询+入账操作）
 *
 * @author
 * @version CcbQueryOrderStatusResponse.java, v 0.1 2022-07-05 10:10:15
 */
@Data
public class CcbQueryOrderStatusResponse  extends CcbPayBaseResponse implements Serializable {

    private static final long serialVersionUID = -2213838555967258628L;


    /**
     * 订单结果
     * Y：成功N：失败U：不确定（交易超时，建议通过订单查询确认扣款结果）Q：待轮询（需按照[3.2.3.支付及轮询流程说明]继续调用轮询接口查询订单结果）其他无法明确订单结果的情况，均继续调用轮询接口查询
     *
     * 示例：Y
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "result长度不能超过1")
    @JSONField(name = "RESULT")
    private String result;

    /**
     * 订单号
     * 从请求参数中获得
     *
     * 示例：20180906101102
     * (特殊必填)
     */
    @Length(max = 30, message = "orderid长度不能超过30")
    @JSONField(name = "ORDERID")
    private String orderid;

    /**
     * 订单金额
     * 该笔订单的资金总额
     *
     * 示例：0.01
     * (特殊必填)
     */
    @Length(max = 16, message = "amount长度不能超过16")
    @JSONField(name = "AMOUNT")
    private String amount;

    /**
     * 等待时间
     * RESULT为Q（待轮询）时返回，单位：秒建议商户按返回等待相应时间后再发起轮询
     *
     * 示例：5
     * (特殊必填)
     */
    @Length(max = 2, message = "waittime长度不能超过2")
    @JSONField(name = "WAITTIME")
    private String waittime;

    /**
     * 全局事件跟踪号
     * 建行交易流水号
     *
     * 示例：1010113861527649530264100
     * (特殊必填)
     */
    @Length(max = 30, message = "traceid长度不能超过30")
    @JSONField(name = "TRACEID")
    private String traceid;

    /**
     * 客户识别号
     * 客户识别码。当RETURN_FIELD字段第一位上送1时返回。银联渠道不返回。RESULT为Q，该字段不返回，需发轮询接口（PAY101）获取。此字段不参与验签
     *
     * 示例：99915236154128
     * (特殊必填)
     */
    @Length(max = 100, message = "openid长度不能超过100")
    @JSONField(name = "OPENID")
    private String openid;

    /**
     * 用户子标识
     * 微信支付专有字段。当RETURN_FIELD字段第一位上送1时返回。子商户appid下用户唯一标识，如需返回则请求时需要传sub_appid。RESULT为Q，该字段不返回，需发轮询接口（PAY101）获取。此字段不参与验签
     *
     * 示例：oZQ9N5YdEISznlF0hk2vedjMBe9A
     * (特殊必填)
     */
    @Length(max = 128, message = "subOpenid长度不能超过128")
    @JSONField(name = "SUB_OPENID")
    private String subOpenid;

    /**
     * 客户实付金额
     * 客户实付金额。当RETURN_FIELD字段第二位上送1时返回。当客户使用龙支付且享受优惠时，该参数有值。RESULT为Q，该字段不返回，需发轮询接口（PAY101）获取。此字段不参与验签
     *
     * 示例：2.00
     * (特殊必填)
     */
    @JSONField(name = "PAID_AMOUNT")
    private String paidAmount;

    /**
     * 商户实收金额
     * 商户实收金额。当RETURN_FIELD字段第二位上送1时返回。当客户使用龙支付且享受优惠时，该参数有值。RESULT为Q，该字段不返回，需发轮询接口（PAY101）获取。此字段不参与验签
     *
     * 示例：3.00
     * (特殊必填)
     */
    @JSONField(name = "RECEIPT_AMOUNT")
    private String receiptAmount;

    /**
     * 优惠活动数组
     * 优惠活动名。当RETURN_FIELD字段第二位上送1时返回。RESULT为Q，该字段不返回，需发轮询接口（PAY101）获取。此字段不参与验签
     *
     * 示例：字段说明见下方[3.1.2.1优惠活动数组字段说明]格式如下：“COUPONARRAY”:[{COUPONNAME:”随机立减”,COUPONTxnAmt:”0.01”},{COUPONNAME:”商户优惠券”,COUPONTxnAmt:”0.01”}]
     * (特殊必填)
     */
    @JSONField(name = "COUPONARRAY")
    private String couponarray;

    /**
     * 支付详细信息
     * 支付详细信息。当RETURN_FIELD字段第四位上送1时返回。RESULT为Q，该字段不返回，需发轮询接口（PAY101）获取。此字段不参与验签。
     *
     * 示例：字段说明见下方[3.1.1.2支付详细信息字段说明]格式如下："PAYMENT_DETAILS": {TYPE:"ALIPAY",PAY_CHANNEL:"BANKCARD",DEBIT_CREDIT_TYPE:"DEBIT_CARD",THIRD_TRADE_NO:"2018010521001004890523646975"}
     * (特殊必填)
     */
    @JSONField(name = "PAYMENT_DETAILS")
    private String paymentDetails;

    /**
     * 微信优惠金额
     * 微信优惠金额。当RETURN_FIELD第5位为1时返回。RESULT为Q，该字段不返回，需发轮询接口（PAY101）获取。此字段不参与验签。
     *
     * 示例：字段说明见下方[3.1.1.3微信优惠金额字段说明]格式如下："COUPONAMOUNT_WX":{"CASH_FEE":"100.00","SETTLEMENT_TOTAL_FEE":"120.00","COUPON_FEE":"50.00"}
     * (特殊必填)
     */
    @JSONField(name = "COUPONAMOUNT_WX")
    private String couponamountWx;

    /**
     * 微信优惠详情
     * 微信优惠详情。当RETURN_FIELD第5位为1时返回。RESULT为Q，该字段不返回，需发轮询接口（PAY101）获取。此字段不参与验签。
     *
     * 示例：字段说明见下方[3.1.1.4微信优惠详细信息字段说明]格式如下："promotion_detail":[{"promotion_id":"109519","name":"单品惠-6","scope":"SINGLE","type":"DISCOUNT","amount":5,"activity_id":"931386","wxpay_contribute":"0",merchant_contribute":"0",other_contribute":"5",goods_detail":[{"goods_id":"a_goods1","goods_remark":"商品备注","quantity":7,"price":1,"discount_amount":4},{"goods_id":"a_goods2","goods_remark":"商品备注","quantity":1,"price":2,"discount_amount":1}]}]备注：Int型参数值不带双引号，String型参数值带双引号。
     * (特殊必填)
     */
    @JSONField(name = "promotion_detail")
    private String promotionDetail;

    /**
     * 支付宝优惠金额
     * 支付宝优惠金额。当RETURN_FIELD第6位为1时返回。RESULT为Q，该字段不返回，需发轮询接口（PAY101）获取。此字段不参与验签。
     *
     * 示例：字段说明见下方[3.1.2.5支付宝优惠金额字段说明]格式如下："COUPONAMOUNT_ALI":{" BUYER_PAY_AMOUNT ":"100.00"," RECEIPT_AMOUNT ":"100.00","COUPON_AMOUNT":"50.00"}
     * (特殊必填)
     */
    @JSONField(name = "COUPONAMOUNT_ALI")
    private String couponamountAli;

    /**
     * 支付宝单品券优惠信息
     * 本次交易支付所使用的单品券优惠的商品优惠信息。当RETURN_FIELD第6位为1时返回。RESULT为Q，该字段不返回，需发轮询接口（PAY101）获取。此字段不参与验签。
     *
     * 示例：“discount_goods_detail”:[{"goods_id":"STANDARD1026181538","goods_name":"雪碧","discount_amount":"100.00","voucher_id":"2015102600073002039000002D5O"}]
     * (特殊必填)
     */
    @JSONField(name = "discount_goods_detail")
    private String discountGoodsDetail;

    /**
     * 支付宝所有优惠券信息
     * 本交易支付时使用的所有优惠券信息。当RETURN_FIELD第6位为1时返回。RESULT为Q，该字段不返回，需发轮询接口（PAY101）获取。此字段不参与验签。
     *
     * 示例：字段说明见下方[3.1.2.6支付宝所有优惠券信息字段说明]格式如下："voucher_detail_list": [{"id": "2015102600073002039000002D5O","name": "XX超市5折优惠","type": "ALIPAY_FIX_VOUCHER","amount": 10,"merchant_contribute": 9,"other_contribute": 1,"memo": "学生专用优惠","template_id": "20171030000730015359000EMZP0","purchase_buyer_contribute": 2.01,"purchase_merchant_contribute": 1.03,"purchase_ant_contribute": 0.82}]
     * (特殊必填)
     */
    @JSONField(name = "voucher_detail_list")
    private String voucherDetailList;

    /**
     * 错误码
     * 报错时返回
     *
     * 示例：9001
     * (特殊必填)
     */
    @Length(max = 12, message = "errcode长度不能超过12")
    @JSONField(name = "ERRCODE")
    private String errcode;

    /**
     * 错误信息
     * 报错时返回
     *
     * 示例：未查询到该笔订单。
     * (特殊必填)
     */
    @Length(max = 80, message = "errmsg长度不能超过80")
    @JSONField(name = "ERRMSG")
    private String errmsg;

    /**
     * 签名
     * 签名串，签名源文格式见下方说明，验签方法详见[4.2.返回报文验签方法]
     *
     * 示例：20924b4c8018c591c62d05fffaa32c0009613050c2b739002b0228e74
     * (特殊必填)
     */
    @Length(max = 200, message = "sign长度不能超过200")
    @JSONField(name = "SIGN")
    private String sign;

}