/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.ccbpay.enums.wlpt;

import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.enums.base.CcbApiTypeEnum;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.request.wlpt.*;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import com.fshows.ccbpay.response.wlpt.CcbLargeFileDownloadResponse;
import com.fshows.ccbpay.response.wlpt.*;

/**
 * @author wangqilei
 * @version CcbWlptApiDefinitionEnum.java, v 0.1 2024-05-07 6:09 PM wangqilei
 */
public enum CcbWlptApiDefinitionEnum implements ICcbPayApiDefinition {
    TRADE_QUERY(
            "商户支付流水查询",
            "5W1002",
            CcbWlOrderQueryRequest.class,
            CcbWlOrderQueryResponse.class,
            CcbApiTypeEnum.OUT_CONNECT_PLATFORM
    ),
    REFUND_CREATE(
            "退款申请发起",
            "5W1004",
            CcbRefundRequest.class,
            CcbRefundResponse.class,
            CcbApiTypeEnum.OUT_CONNECT_PLATFORM
    ),
    MRCH_REFUND_CREATE(
            "集团商户退款申请发起",
            "5W1024",
            CcbRefundRequest.class,
            CcbRefundResponse.class,
            CcbApiTypeEnum.OUT_CONNECT_PLATFORM
    ),
    REFUND_QUERY(
            "退款查询",
            "5W1003",
            CcbRefundQueryRequest.class,
            CcbRefundQueryResponse.class,
            CcbApiTypeEnum.OUT_CONNECT_PLATFORM
    ),
    ORDER_FILE(
            "商户流水文件下载请求",
            "5W1005",
            CcbOrderFileRequest.class,
            CcbOrderFileResponse.class,
            CcbApiTypeEnum.OUT_CONNECT_PLATFORM
    ),
    LARGE_FILE_DOWNLOAD(
            "大文件下载",
            "6W0111",
            CcbLargeFileDownloadRequest.class,
            CcbLargeFileDownloadResponse.class,
            CcbApiTypeEnum.OUT_CONNECT_PLATFORM
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String txCode;
    /**
     * 请求Class类型
     */
    private Class requestClass;
    /**
     * 响应Class类型
     */
    private Class responseClass;
    /**
     * API类型
     */
    private CcbApiTypeEnum ccbApiTypeEnum;

    CcbWlptApiDefinitionEnum(String name, String txCode, Class requestClass, Class responseClass, CcbApiTypeEnum ccbApiTypeEnum) {
        this.name = name;
        this.txCode = txCode;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
        this.ccbApiTypeEnum = ccbApiTypeEnum;
    }

    @Override
    public String getApiSubURI() {
        return "";
    }

    @Override
    public <T extends CcbPayBaseRequest> Class<T> getRequestClass() {
        return requestClass;
    }

    @Override
    public <T extends CcbPayBaseResponse> Class<T> getResponseClass() {
        return responseClass;
    }

    public String getTxCode() {
        return txCode;
    }
}