/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.ccbpay.client.impl;

import ccb.pay.api.util.CCBPayUtil;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.ccbpay.annotation.NeedSign;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.ISigner;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import com.fshows.ccbpay.util.LogUtil;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;


/**
 * 建行开放平台加签默认实现
 *
 * @author liluqing
 * @version DefaultSignerImpl.java, v 0.1 2022-03-02 18:32
 */
@Slf4j
public class CcbPayApiSignerImpl<T extends CcbPayBaseRequest, R extends CcbPayBaseResponse> implements ISigner<T, R> {

    @Override
    public String sign(T request, ApiClientConfig apiClientConfig) throws CcbPayApiException {
        // 执行加签动作
        return null;
    }

    @Override
    public Boolean verifySign(R response, ApiClientConfig apiClientConfig) throws CcbPayApiException {
        try {

            // 构建签名原文
            String oriSignData = buildOriSignData(response);
            LogUtil.info(log, "【ccbpay-sdk】验签原文 >> sign={}", oriSignData);
            String pubKey = apiClientConfig.getCcbPayPublicKey();
            CCBPayUtil ccbPayUtil = new CCBPayUtil();
            boolean result = ccbPayUtil.verifyNotifySign(oriSignData, response.getSign(), pubKey);
            return result;
        } catch (Exception e) {
            LogUtil.error(log, "【ccbpay-sdk】建行开放平台响应结果验签失败 >> response={}", e, response);
            throw new CcbPayApiException("建行开放平台响应结果验签失败", e);
        }
    }


    /**
     * 获取验签原文
     * @param response
     * @return {@link String}
     */
    private String buildOriSignData(R response) {
        Field[] fields = response.getClass().getDeclaredFields();
        List<Field> orderedFields = new ArrayList<>();

        // 获取标注了Order注解的字段
        for (Field field : fields) {
            NeedSign orderAnnotation = field.getAnnotation(NeedSign.class);
            if (orderAnnotation != null) {
                orderedFields.add(field);
            }
        }
        // 按照Order注解的值排序字段
        orderedFields.sort(Comparator.comparingInt(field -> field.getAnnotation(NeedSign.class).value()));
        // 拼接排序后的字段值
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < orderedFields.size(); i++) {
            Field field = orderedFields.get(i);
            try {
                field.setAccessible(true);
                // 获取json值
                JSONField annotation = field.getAnnotation(JSONField.class);
                if (i !=0 ) {
                    result.append("&");
                }
                result.append(annotation.name()).append("=").append(field.get(response) == null ? "" : field.get(response));
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result.toString().trim();
    }


}