/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.web.interceptor;

import com.alibaba.fastjson.JSON;
import com.fshows.auth.base.response.auth.UserInfoRes;
import com.fshows.auth.common.enums.EnumInterface;
import com.fshows.auth.common.enums.exception.SysExceptionEnum;
import com.fshows.auth.common.exception.BusinessException;
import com.fshows.auth.common.redis.RedisCache;
import com.fshows.auth.facade.result.ApiResponse;
import java.io.PrintWriter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class LoginCheckInterceptor
implements HandlerInterceptor {
    @Resource
    private RedisCache redisCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String token = request.getHeader("token");
        UserInfoRes userInfoResult = null;
        if (StringUtils.isNotBlank((CharSequence)token)) {
            userInfoResult = (UserInfoRes)this.redisCache.hGet("fshows.auth.user.token", token, UserInfoRes.class);
        }
        BusinessException exception = null;
        if (null == userInfoResult) {
            exception = new BusinessException((EnumInterface)SysExceptionEnum.SYSTEM_NOT_LOGIN_ERROR, new Object[0]);
        }
        if (exception != null) {
            try (PrintWriter writer = null;){
                response.setContentType("application/json;charset=utf-8");
                response.setHeader("Access-Control-Allow-Credentials", "true");
                writer = response.getWriter();
                writer.write(JSON.toJSONString((Object)ApiResponse.error((String)exception.getCode(), (String)exception.getMessage())));
                writer.flush();
            }
            return false;
        }
        request.getSession().setAttribute("login_user", (Object)userInfoResult);
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }
}

