/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.web.aspect;

import com.fshows.auth.common.util.SystemClock;
import java.lang.reflect.Method;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ControllerAspect {
    private static final Logger digestLogger = LoggerFactory.getLogger((String)"SERVICE-DIGEST");
    private static final Logger defaultLogger = LoggerFactory.getLogger((String)"SERVICE-DEFAULT");
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerAspect.class);
    private static Random random = new Random();

    @Pointcut(value="execution(public * com.fshows.auth.web.controller.*.*(..))")
    private void allMethod() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="allMethod()")
    public Object doAround(ProceedingJoinPoint call) throws Throwable {
        Object object;
        MethodSignature signature = (MethodSignature)call.getSignature();
        Method method = signature.getMethod();
        String[] classNameArray = method.getDeclaringClass().getName().split("\\.");
        String methodName = classNameArray[classNameArray.length - 1] + "  >>> " + method.getName();
        String params = this.buildParamsDefault(call);
        long start = SystemClock.millisClock().now();
        String reqId = ControllerAspect.getRandom(10);
        Object result = null;
        try {
            LOGGER.info("[{},\u540e\u53f0\u7f51\u5173\u8bf7\u6c42\u5f00\u59cb] \u65b9\u6cd5\u540d\uff1a{}, \u8bf7\u6c42\u53c2\u6570{}", new Object[]{reqId, methodName, params});
            object = result = call.proceed();
        }
        catch (Throwable throwable) {
            long runTimes = SystemClock.millisClock().now() - start;
            LOGGER.info("[{},\u540e\u53f0\u7f51\u5173\u8bf7\u6c42\u7ed3\u675f] \u65b9\u6cd5\u540d\uff1a{}, \u8017\u65f6\uff1a{} \u6beb\u79d2", new Object[]{reqId, methodName, runTimes});
            throw throwable;
        }
        long runTimes = SystemClock.millisClock().now() - start;
        LOGGER.info("[{},\u540e\u53f0\u7f51\u5173\u8bf7\u6c42\u7ed3\u675f] \u65b9\u6cd5\u540d\uff1a{}, \u8017\u65f6\uff1a{} \u6beb\u79d2", new Object[]{reqId, methodName, runTimes});
        return object;
    }

    private String buildParamsDefault(ProceedingJoinPoint call) {
        String params = " [";
        for (int i = 0; i < call.getArgs().length; ++i) {
            Object obj = call.getArgs()[i];
            if (null != obj) {
                String str;
                if (obj instanceof HttpServletRequest || (str = obj.toString()).contains("UserInfoRes")) continue;
                if (obj.getClass() != String.class) {
                    str = ToStringBuilder.reflectionToString((Object)obj, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
                }
                params = i != call.getArgs().length - 1 ? params + str + "," : params + str + " ]";
            }
            if (params.length() != 1) continue;
            params = params + "]";
        }
        return params;
    }

    private static String getRandom(int length) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            boolean isChar;
            boolean bl = isChar = random.nextInt(2) % 2 == 0;
            if (isChar) {
                int choice = random.nextInt(2) % 2 == 0 ? 65 : 97;
                ret.append((char)(choice + random.nextInt(26)));
                continue;
            }
            ret.append(Integer.toString(random.nextInt(10)));
        }
        return ret.toString();
    }
}

