/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.web.advice;

import com.fshows.auth.common.enums.exception.SysExceptionEnum;
import com.fshows.auth.common.exception.BaseException;
import com.fshows.auth.facade.result.ApiResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@EnableAspectJAutoProxy
public class ExceptionAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionAdvice.class);

    @CrossOrigin
    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public ApiResponse defaultExceptionHandler(Exception exception) {
        ApiResponse result = new ApiResponse();
        result.setSuccess(false);
        try {
            throw exception;
        }
        catch (MethodArgumentNotValidException argEx) {
            FieldError fieldError = argEx.getBindingResult().getFieldError();
            String errorMsg = String.format("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38: %s%s", fieldError.getField(), fieldError.getDefaultMessage());
            LOGGER.error("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38  >>  {}", (Object)errorMsg);
            result.setErrorCode(SysExceptionEnum.INVALID_PARAM.getCode());
            result.setErrorMsg(errorMsg);
        }
        catch (BaseException e) {
            LOGGER.error("\u51fa\u73b0\u5f02\u5e38  stack={}", (Throwable)e);
            result.setErrorCode(e.getCode());
            result.setErrorMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u672a\u77e5\u5f02\u5e38 ", (Throwable)e);
            result.setErrorCode(SysExceptionEnum.SYSTEM_ERROR.getCode());
            result.setErrorMsg(SysExceptionEnum.SYSTEM_ERROR.getMsg());
        }
        return result;
    }
}

