/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.common.util;

import com.fshows.auth.common.common.ValidateResult;
import com.fshows.auth.common.enums.exception.SysExceptionEnum;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;

public class ValidatorUtils {
    private static Validator getValidator() {
        return ValidatorHolder.validator;
    }

    private ValidatorUtils() {
    }

    public static ValidateResult validate(Object validObject) {
        ValidateResult validateResult = new ValidateResult();
        Set violations = ValidatorUtils.getValidator().validate(validObject, new Class[0]);
        if (!violations.isEmpty()) {
            ConstraintViolation v = (ConstraintViolation)violations.iterator().next();
            validateResult.fail(SysExceptionEnum.INVALID_PARAM.getCode(), SysExceptionEnum.INVALID_PARAM.getMsg() + ":" + v.getMessage());
        } else {
            validateResult.success();
        }
        return validateResult;
    }

    private static class ValidatorHolder {
        private static Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

        private ValidatorHolder() {
        }
    }
}

