/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.common.redis;

import com.fshows.auth.common.redis.RedisClient;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPool;

@Component
public class RedisLock {
    private static final Long ONE = 1L;
    private static final String DEFAULT_LOCK_VALUE = "1";
    private static final String OK = "OK";
    private static final String SET_IF_NOT_EXIST = "NX";
    private static final String SET_WITH_EXPIRE_TIME = "PX";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private RedisClient redisClient;

    public boolean tryGetLock(String lockKey, String requestId, int expireTime) {
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            String result = jedis.set(lockKey, requestId, SET_IF_NOT_EXIST, SET_WITH_EXPIRE_TIME, expireTime);
            if (OK.equals(result)) {
                return true;
            }
            return false;
        });
    }

    public boolean tryGetLock(String lockKey, int expireTime) {
        return this.tryGetLock(lockKey, DEFAULT_LOCK_VALUE, expireTime);
    }

    public boolean releaseLock(String lockKey, String requestId) {
        String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            Object result = jedis.eval(script, Collections.singletonList(lockKey), Collections.singletonList(requestId));
            if (ONE.equals(result)) {
                return true;
            }
            return false;
        });
    }

    public void releaseLock(String lockKey) {
        this.redisClient.invoke(this.jedisPool, jedis -> {
            jedis.del(lockKey);
            return null;
        });
    }
}

