/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.base.biz.auth;

import com.alibaba.fastjson.JSON;
import com.fshows.auth.base.biz.auth.AuthBiz;
import com.fshows.auth.base.integration.dingding.DingDingIntegration;
import com.fshows.auth.base.integration.dingding.entity.DingUserByCodeResponse;
import com.fshows.auth.base.integration.dingding.entity.DingUserByUnionidResponse;
import com.fshows.auth.base.integration.dingding.entity.DingUserByUseridResponse;
import com.fshows.auth.base.request.auth.ApplyAuthReq;
import com.fshows.auth.base.request.auth.GetUserByCodeReq;
import com.fshows.auth.base.response.auth.ApplyAuthRes;
import com.fshows.auth.base.response.auth.GetUserByCodeRes;
import com.fshows.auth.base.response.auth.UserInfoRes;
import com.fshows.auth.common.config.property.BaseProperty;
import com.fshows.auth.common.config.property.DingDingProperty;
import com.fshows.auth.common.enums.EnumInterface;
import com.fshows.auth.common.enums.exception.auth.AuthExceptionEnum;
import com.fshows.auth.common.exception.BusinessException;
import com.fshows.auth.common.redis.RedisCache;
import com.fshows.auth.common.util.TimeSerialUtil;
import com.fshows.auth.common.util.TokenProccessor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthBizImpl
implements AuthBiz {
    private static final Logger log = LoggerFactory.getLogger(AuthBizImpl.class);
    @Autowired
    private DingDingProperty dingDingProperty;
    @Autowired
    private BaseProperty baseProperty;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private DingDingIntegration dingDingIntegration;

    @Override
    public String getQrCodeUrl(String redirectUrl) {
        String randomId = TimeSerialUtil.createTimeSerial();
        log.info("\u3010{}\u3011\u83b7\u53d6\u9489\u9489\u4e8c\u7ef4\u7801url\u63a5\u53e3 \u5f00\u59cb >> redirectUrl={}", (Object)randomId, (Object)redirectUrl);
        StringBuilder qrCodeUrl = new StringBuilder("https://oapi.dingtalk.com/connect/oauth2/sns_authorize?response_type=code&scope=snsapi_login");
        qrCodeUrl.append("&appid=" + this.dingDingProperty.getMoveAppKey());
        qrCodeUrl.append("&redirect_uri=" + this.baseProperty.getScanCodeMiddlePage());
        qrCodeUrl.append("&state=" + (StringUtils.isEmpty((CharSequence)redirectUrl) ? "" : redirectUrl));
        log.info("\u3010{}\u3011\u83b7\u53d6\u9489\u9489\u4e8c\u7ef4\u7801url\u63a5\u53e3 \u7ed3\u675f >> redirectUrl={}\uff0cqrCodeUrl={}", new Object[]{randomId, redirectUrl, qrCodeUrl.toString()});
        return qrCodeUrl.toString();
    }

    @Override
    public ApplyAuthRes applyAuth(ApplyAuthReq req) {
        String redirectUrl;
        String randomId = TimeSerialUtil.createTimeSerial();
        log.info("\u3010{}\u3011\u7533\u8bf7\u8ba4\u8bc1\u63a5\u53e3 \u5f00\u59cb >> param={}", (Object)randomId, JSON.toJSON((Object)req));
        ApplyAuthRes result = new ApplyAuthRes();
        String string = redirectUrl = StringUtils.isEmpty((CharSequence)req.getRedirectUrl()) ? "" : "?redirectUrl=" + req.getRedirectUrl();
        if (StringUtils.isEmpty((CharSequence)req.getToken())) {
            result.setAuthResult(false);
            result.setRedirectUrl(this.baseProperty.getScanCodePage() + redirectUrl);
            log.info("\u3010{}\u3011\u7533\u8bf7\u8ba4\u8bc1\u63a5\u53e3 token\u4e3a\u7a7a >> param={}\uff0cresult={}", new Object[]{randomId, JSON.toJSON((Object)req), JSON.toJSON((Object)result)});
            return result;
        }
        UserInfoRes userInfoResult = (UserInfoRes)this.redisCache.hGet("fshows.auth.user.token", req.getToken(), UserInfoRes.class);
        if (userInfoResult == null) {
            result.setAuthResult(false);
            result.setRedirectUrl(this.baseProperty.getScanCodePage() + redirectUrl);
        } else {
            this.redisCache.hSet("fshows.auth.user.unionid", userInfoResult.getUnionid(), (Object)userInfoResult, 7200, TimeUnit.SECONDS);
            this.redisCache.hSet("fshows.auth.user.token", userInfoResult.getToken(), (Object)userInfoResult, 7200, TimeUnit.SECONDS);
            result.setAuthResult(true);
            result.setUnionid(userInfoResult.getUnionid());
            result.setNickname(userInfoResult.getNickname());
            result.setAvatar(userInfoResult.getAvatar());
        }
        log.info("\u3010{}\u3011\u7533\u8bf7\u8ba4\u8bc1\u63a5\u53e3 \u7ed3\u675f >> param={}\uff0cresult={}", new Object[]{randomId, JSON.toJSON((Object)req), JSON.toJSON((Object)result)});
        return result;
    }

    @Override
    public GetUserByCodeRes getUserByCode(GetUserByCodeReq req) {
        String randomId = TimeSerialUtil.createTimeSerial();
        log.info("\u3010{}\u3011\u6839\u636ecode\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u63a5\u53e3 \u5f00\u59cb >> param={}", (Object)randomId, JSON.toJSON((Object)req));
        DingUserByCodeResponse userInfo = this.dingDingIntegration.getUserByCode(req.getCode());
        if (userInfo.getErrcode() != 0L) {
            log.info("\u3010{}\u3011\u6839\u636ecode\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u63a5\u53e3 \u83b7\u53d6\u9489\u9489\u7528\u6237unionid\u5f02\u5e38 >> param={}\uff0cresponse={}", new Object[]{randomId, JSON.toJSON((Object)req), JSON.toJSON((Object)userInfo)});
            throw new BusinessException(AuthExceptionEnum.AUTH_DING_DING_ERROR.getCode(), userInfo.getErrmsg());
        }
        String unionid = userInfo.getUserInfo().getUnionid();
        DingUserByUnionidResponse user = this.dingDingIntegration.getUserContactType(unionid);
        if (user.getErrcode() != 0L) {
            log.info("\u3010{}\u3011\u6839\u636ecode\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u63a5\u53e3 \u83b7\u53d6\u9489\u9489\u7528\u6237\u5458\u5de5\u7c7b\u578b\u5f02\u5e38 >> param={}\uff0cresponse={}", new Object[]{randomId, JSON.toJSON((Object)req), JSON.toJSON((Object)user)});
            throw new BusinessException(AuthExceptionEnum.AUTH_DING_DING_ERROR.getCode(), user.getErrmsg());
        }
        if (user.getErrcode() == 0L && user.getContactType() != 0L) {
            log.info("\u3010{}\u3011\u6839\u636ecode\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u63a5\u53e3 \u9489\u9489\u7528\u6237\u4e0d\u5c5e\u4e8e\u5185\u90e8\u5458\u5de5 >> param={}\uff0cresponse={}", new Object[]{randomId, JSON.toJSON((Object)req), JSON.toJSON((Object)user)});
            throw new BusinessException((EnumInterface)AuthExceptionEnum.AUTH_IS_NOT_EMPLOYEE, new Object[0]);
        }
        String token = "";
        UserInfoRes userInfoRes = (UserInfoRes)this.redisCache.hGet("fshows.auth.user.unionid", unionid, UserInfoRes.class);
        if (userInfoRes != null) {
            token = userInfoRes.getToken();
        } else {
            token = TokenProccessor.getInstance().makeToken();
            DingUserByUseridResponse userDetail = this.dingDingIntegration.getUserByUserid(user.getUserid());
            if (userDetail.getErrcode() != 0L) {
                log.info("\u3010{}\u3011\u6839\u636ecode\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u63a5\u53e3 \u83b7\u53d6\u7528\u6237\u8be6\u60c5\u5f02\u5e38 >> param={}\uff0cresponse={}", new Object[]{randomId, JSON.toJSON((Object)req), JSON.toJSON((Object)userDetail)});
                throw new BusinessException(AuthExceptionEnum.AUTH_DING_DING_ERROR.getCode(), userDetail.getErrmsg());
            }
            userInfoRes = new UserInfoRes();
            userInfoRes.setUnionid(userDetail.getUnionid());
            userInfoRes.setToken(token);
            userInfoRes.setNickname(userDetail.getNickname());
            userInfoRes.setAvatar(userDetail.getAvatar());
        }
        this.redisCache.hSet("fshows.auth.user.unionid", unionid, (Object)userInfoRes, 7200, TimeUnit.SECONDS);
        this.redisCache.hSet("fshows.auth.user.token", token, (Object)userInfoRes, 7200, TimeUnit.SECONDS);
        GetUserByCodeRes getUserByCodeResult = new GetUserByCodeRes();
        getUserByCodeResult.setToken(token);
        return getUserByCodeResult;
    }
}

